/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ListValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;

public class AnchorUsageRanksAttribute
extends ListValueAttribute {
    FieldBinding field;
    List<Integer> ranks;

    public AnchorUsageRanksAttribute(FieldBinding field) {
        super(IOTConstants.ANCHOR_USAGE_RANKS, 0, 2);
        this.field = field;
    }

    public AnchorUsageRanksAttribute(FieldInfo info, int readOffset, int structOffset, int[] constantPoolOffsets) {
        super(ANCHOR_USAGE_RANKS, 0, 2);
        this.readList(info, readOffset, structOffset, constantPoolOffsets);
    }

    @Override
    public boolean setupForWriting() {
        if (this.ranks != null) {
            this._count = this.ranks.size();
        }
        return true;
    }

    public void addUsageRank(int rank) {
        if (this.ranks == null) {
            this.ranks = new ArrayList<Integer>();
        }
        this.ranks.add(rank);
    }

    @Override
    void writeElementValue(int i) {
        this.writeUnsignedShort(this.ranks.get(i));
    }

    @Override
    void read(int i) {
        if (i == 0) {
            this.ranks = new ArrayList<Integer>();
        }
        this.ranks.add(this.consumeShort());
    }

    @Override
    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
    }

    @Override
    public boolean evaluate(FieldBinding binding) {
        this.field = binding;
        FieldModel.getModel(binding).addAttribute(this);
        return true;
    }

    public int[] getRanks() {
        int[] ranks = new int[this._count];
        int i = 0;
        while (i < this._count) {
            ranks[i] = this.ranks.get(i);
            ++i;
        }
        return ranks;
    }

    @Override
    String toString(int i) {
        return this.ranks.get(i).toString();
    }
}

