/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import java.io.File;
import java.util.Date;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.LocalDataProvider;
import org.eclipse.oomph.setup.internal.sync.RemoteDataProvider;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerCredentials;
import org.eclipse.oomph.setup.internal.sync.SynchronizerService;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerLoginDialog;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.PropertyFile;
import org.eclipse.swt.widgets.Shell;

public final class SynchronizerManager {
    public static final SynchronizerManager INSTANCE = new SynchronizerManager();
    public static final boolean ENABLED = PropertiesUtil.isProperty((String)"oomph.setup.sync");
    private static final File USER_SETUP = new File(SetupContext.USER_SETUP_LOCATION_URI.toFileString());
    private static final PropertyFile CONFIG = new PropertyFile(SetupSyncPlugin.INSTANCE.getUserLocation().append("sync.properties").toFile());
    private static final String CONNECTION_OFFERED = "connection.offered";
    private static final String SERVICE_URI = "service.uri";
    private static final String SYNC_ENABLED = "sync.enabled";
    private static final boolean DEBUG = false;
    private Boolean connectionOffered;
    private SynchronizerService service;

    private SynchronizerManager() {
    }

    private void connect(Shell shell) {
        try {
            try {
                SynchronizerService service = this.getService();
                SynchronizerLoginDialog dialog = new SynchronizerLoginDialog(shell, service);
                if (dialog.open() == 0) {
                    SynchronizerCredentials credentials = dialog.getCredentials();
                    service.setCredentials(credentials);
                    this.setSyncEnabled(true);
                }
            }
            catch (Throwable ex) {
                SetupUIPlugin.INSTANCE.log(ex);
                CONFIG.setProperty(CONNECTION_OFFERED, new Date().toString());
                this.connectionOffered = true;
            }
        }
        finally {
            CONFIG.setProperty(CONNECTION_OFFERED, new Date().toString());
            this.connectionOffered = true;
        }
    }

    public void offerFirstTimeConnect(Shell shell) {
        if (!ENABLED) {
            return;
        }
        if (this.connectionOffered == null) {
            String property = CONFIG.getProperty(CONNECTION_OFFERED, null);
            this.connectionOffered = property != null;
        }
        if (!this.connectionOffered.booleanValue()) {
            this.connect(shell);
        }
    }

    public SynchronizerService getService() {
        if (this.service == null) {
            try {
                String property = CONFIG.getProperty(SERVICE_URI, null);
                if (property != null) {
                    this.service = SynchronizerService.Registry.INSTANCE.getService(IOUtil.newURI((String)property));
                }
            }
            catch (Throwable ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
            if (this.service == null) {
                this.service = SynchronizerService.Registry.ECLIPSE_SERVICE;
            }
        }
        return this.service;
    }

    public void setService(SynchronizerService service) {
        if (service == null) {
            CONFIG.removeProperty(SERVICE_URI);
        } else {
            CONFIG.setProperty(SERVICE_URI, service.getServiceURI().toString());
        }
        this.service = service;
    }

    public boolean isSyncEnabled() {
        try {
            return Boolean.parseBoolean(CONFIG.getProperty(SYNC_ENABLED, "false"));
        }
        catch (Throwable ex) {
            SetupUIPlugin.INSTANCE.log(ex);
            return false;
        }
    }

    public void setSyncEnabled(boolean enabled) {
        CONFIG.setProperty(SYNC_ENABLED, Boolean.toString(enabled));
    }

    public Synchronizer createSynchronizer() {
        return this.createSynchronizer(USER_SETUP);
    }

    public Synchronizer createSynchronizer(File userSetup) {
        SynchronizerService service = this.getService();
        File syncFolder = service.getSyncFolder();
        return this.createSynchronizer(userSetup, syncFolder);
    }

    public Synchronizer createSynchronizer(File userSetup, File syncFolder) {
        SynchronizerService service = this.getService();
        LocalDataProvider localDataProvider = new LocalDataProvider(userSetup);
        RemoteDataProvider remoteDataProvider = service.createDataProvider();
        return new Synchronizer((DataProvider)localDataProvider, (DataProvider)remoteDataProvider, syncFolder);
    }
}

