/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileCreator;
import org.eclipse.oomph.targlets.core.ITargletContainerDescriptor;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.Messages;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;

public final class TargletContainerDescriptor
implements ITargletContainerDescriptor,
Comparable<TargletContainerDescriptor> {
    public static final String PROP_TARGLET_CONTAINER_WORKSPACE = "targlet.container.workspace";
    public static final String PROP_TARGLET_CONTAINER_ID = "targlet.container.id";
    public static final String PROP_TARGLET_CONTAINER_DIGEST = "targlet.container.digest";
    private static final IPath INSTALL_FOLDERS = PDECore.getDefault().getStateLocation().append(".install_folders");
    private static final File DEFAULT_INSTALL_FOLDER = INSTALL_FOLDERS.append("default").toFile();
    private static long lastStamp;
    private String id;
    private File poolLocation;
    private String workingDigest;
    private Collection<WorkspaceIUInfo> workingProjects;
    private ITargletContainerDescriptor.UpdateProblem updateProblem;
    private transient BundlePool bundlePool;
    private transient Profile transactionProfile;
    private transient Runnable restoreBundlePoolTimestamps;

    public TargletContainerDescriptor() {
    }

    public TargletContainerDescriptor(String id, File poolLocation) {
        this.id = id;
        this.poolLocation = poolLocation;
    }

    public TargletContainerDescriptor(BinaryResourceImpl.EObjectInputStream stream) throws IOException {
        this.id = stream.readString();
        String path = stream.readString();
        if (path != null) {
            this.poolLocation = new File(path);
        }
        this.workingDigest = stream.readString();
        int size = stream.readInt();
        if (size != 0) {
            this.workingProjects = new ArrayList<WorkspaceIUInfo>();
            int i = 0;
            while (i < size) {
                WorkspaceIUInfo workspaceIUInfo = new WorkspaceIUInfo(stream);
                this.workingProjects.add(workspaceIUInfo);
                ++i;
            }
        }
        if ((size = stream.readInt()) != 0) {
            byte[] bytes = new byte[size];
            int i = 0;
            while (i < size) {
                bytes[i] = stream.readByte();
                ++i;
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                this.updateProblem = (ITargletContainerDescriptor.UpdateProblem)new ObjectInputStream(bais).readObject();
            }
            catch (ClassNotFoundException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
    }

    public void write(BinaryResourceImpl.EObjectOutputStream stream) throws IOException {
        stream.writeString(this.id);
        stream.writeString(this.poolLocation == null ? null : this.poolLocation.getAbsolutePath());
        stream.writeString(this.workingDigest);
        int size = this.workingProjects == null ? 0 : this.workingProjects.size();
        stream.writeInt(size);
        if (size != 0) {
            for (WorkspaceIUInfo workspaceIUInfo : this.workingProjects) {
                workspaceIUInfo.write(stream);
            }
        }
        if (this.updateProblem != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.updateProblem);
            oos.close();
            byte[] bytes = baos.toByteArray();
            stream.writeInt(bytes.length);
            int i = 0;
            while (i < bytes.length) {
                byte b = bytes[i];
                stream.writeByte((int)b);
                ++i;
            }
        } else {
            stream.writeInt(0);
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public File getPoolLocation() {
        return this.poolLocation;
    }

    public File getInstallLocation() {
        String installFolder;
        Profile workingProfile = this.getWorkingProfile();
        if (workingProfile != null && (installFolder = workingProfile.getProperty("org.eclipse.equinox.p2.installFolder")) != null) {
            return new File(installFolder);
        }
        return DEFAULT_INSTALL_FOLDER;
    }

    @Override
    public String getWorkingDigest() {
        return this.workingDigest;
    }

    @Override
    public Collection<WorkspaceIUInfo> getWorkingProjects() {
        return this.workingProjects;
    }

    @Override
    public ITargletContainerDescriptor.UpdateProblem getUpdateProblem() {
        return this.updateProblem;
    }

    @Override
    public synchronized BundlePool getBundlePool() {
        if (this.bundlePool == null) {
            AgentManager agentManager = P2Util.getAgentManager();
            this.bundlePool = agentManager.getBundlePool(this.poolLocation);
        }
        return this.bundlePool;
    }

    @Override
    public int compareTo(TargletContainerDescriptor o) {
        return this.id.compareTo(o.getID());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TargletContainerDescriptor other = (TargletContainerDescriptor)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return NLS.bind((String)"TargletContainerDescriptor[id={0}, workingDigest={1}]", (Object)this.id, (Object)this.workingDigest);
    }

    Profile startUpdateTransaction(String environmentProperties, String nlProperty, String digest, IProgressMonitor monitor) throws CoreException {
        if (this.transactionProfile != null) {
            throw new ProvisionException(Messages.TargletContainerDescriptor_ConflictingTransaction_exception);
        }
        this.transactionProfile = this.getOrCreateProfile(this.id, this.poolLocation, environmentProperties, nlProperty, digest, monitor);
        this.restoreBundlePoolTimestamps = P2Util.preserveBundlePoolTimestamps((File)this.poolLocation);
        return this.transactionProfile;
    }

    void commitUpdateTransaction(String digest, Collection<WorkspaceIUInfo> workspaceIUInfos, IProgressMonitor monitor) throws CoreException {
        if (this.transactionProfile == null) {
            throw new ProvisionException(Messages.TargletContainerDescriptor_NoTransaction_exception);
        }
        if (this.restoreBundlePoolTimestamps != null) {
            this.restoreBundlePoolTimestamps.run();
            this.restoreBundlePoolTimestamps = null;
        }
        this.transactionProfile = null;
        this.workingDigest = digest;
        this.workingProjects = workspaceIUInfos;
        this.resetUpdateProblem();
        TargletContainerDescriptor.saveDescriptors(monitor);
    }

    void rollbackUpdateTransaction(Throwable t, IProgressMonitor monitor) throws CoreException {
        if (this.restoreBundlePoolTimestamps != null) {
            this.restoreBundlePoolTimestamps.run();
            this.restoreBundlePoolTimestamps = null;
        }
        this.transactionProfile = null;
        if (t != null) {
            this.updateProblem = ITargletContainerDescriptor.UpdateProblem.create(t);
            TargletContainerDescriptor.saveDescriptors(monitor);
        }
    }

    void resetUpdateProblem() {
        this.updateProblem = null;
    }

    @Override
    public String getWorkingProfileID() {
        if (this.workingDigest == null) {
            return null;
        }
        return TargletContainerDescriptor.getProfileID(this.workingDigest);
    }

    @Override
    public Profile getWorkingProfile() {
        String profileID = this.getWorkingProfileID();
        if (profileID == null) {
            return null;
        }
        BundlePool bundlePool = this.getBundlePool();
        if (bundlePool == null) {
            return null;
        }
        return bundlePool.getProfile(profileID);
    }

    private Profile getOrCreateProfile(String id, File poolLocation, String environmentProperties, String nlProperty, String digest, IProgressMonitor monitor) throws CoreException {
        File installFolder;
        String profileID;
        AgentManager agentManager = P2Util.getAgentManager();
        BundlePool bundlePool = agentManager.getBundlePool(poolLocation);
        Profile profile = bundlePool.getProfile(profileID = TargletContainerDescriptor.getProfileID(digest));
        if (profile != null && (installFolder = profile.getInstallFolder()) == null) {
            profile.delete(true);
            profile = null;
        }
        if (profile == null) {
            ProfileCreator creator = bundlePool.addProfile(profileID, "Targlet");
            creator.set(PROP_TARGLET_CONTAINER_WORKSPACE, TargletContainerDescriptorManager.WORKSPACE_LOCATION);
            creator.set(PROP_TARGLET_CONTAINER_ID, id);
            creator.set(PROP_TARGLET_CONTAINER_DIGEST, digest);
            creator.set("org.eclipse.equinox.p2.installFolder", INSTALL_FOLDERS.append(Long.toString(TargletContainerDescriptor.nextTimeStamp())).toOSString());
            creator.setEnvironments(environmentProperties);
            creator.setLanguages(nlProperty);
            creator.setInstallFeatures(true);
            creator.setReferencer(TargletContainerDescriptorManager.WORKSPACE_REFERENCER_FILE);
            profile = creator.create();
        }
        return profile;
    }

    private static String getProfileID(String suffix) {
        return IOUtil.encodeFileName((String)(TargletContainerDescriptorManager.WORKSPACE_LOCATION + "-" + suffix));
    }

    private static void saveDescriptors(IProgressMonitor monitor) throws CoreException {
        TargletContainerDescriptorManager manager = TargletContainerDescriptorManager.getInstance();
        manager.saveDescriptors(monitor);
    }

    private static synchronized long nextTimeStamp() {
        long stamp = System.currentTimeMillis();
        if (stamp == lastStamp) {
            ++stamp;
        }
        lastStamp = stamp;
        return stamp;
    }
}

