/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetupUtil {
    private static final String DEFAULT_INSTALLER_UPDATE_URL = "http://download.eclipse.org/oomph/products/repository";
    private static final String RESOLVING_TARGET_PLATFORM_DEFINITIONS = "oomph.setup.resolving.target.platform.definitions";
    public static final String INSTALLER_UPDATE_URL = PropertiesUtil.getProperty((String)"oomph.installer.update.url", (String)"http://download.eclipse.org/oomph/products/repository").replace('\\', '/');
    public static final String INSTALLER_PRODUCT_ID = "org.eclipse.oomph.setup.installer.product";
    public static final boolean INSTALLER_PRODUCT = PropertiesUtil.getProperty((String)"eclipse.product").equals("org.eclipse.oomph.setup.installer.product");
    public static final boolean SETUP_ARCHIVER_APPLICATION = "org.eclipse.oomph.setup.core.SetupArchiver".equals(PropertiesUtil.getProperty((String)"eclipse.application"));

    private SetupUtil() {
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = StringExpander.STRING_EXPANSION_PATTERN.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        StringBuffer result = new StringBuffer();
        do {
            String group1;
            if ("$".equals(group1 = matcher.group(1))) {
                matcher.appendReplacement(result, "\\$\\$\\$\\$");
                continue;
            }
            matcher.appendReplacement(result, "\\$$0");
        } while (matcher.find());
        matcher.appendTail(result);
        int i = 0;
        int length = result.length();
        while (i < length) {
            char c = result.charAt(i);
            if (c < StringExpander.CONTROL_CHARACTER_REPLACEMENTS.length && c != '\n' && c != '\r' && c != '\t') {
                String replacement = StringExpander.CONTROL_CHARACTER_REPLACEMENTS[c];
                result.replace(i, i + 1, replacement);
                length += replacement.length() - 1;
            }
            ++i;
        }
        return result.toString();
    }

    public static Set<String> getResolvingTargetDefinitions(SetupTaskContext context) {
        LinkedHashSet targetDefinitions = (LinkedHashSet)context.get(RESOLVING_TARGET_PLATFORM_DEFINITIONS);
        if (targetDefinitions == null) {
            targetDefinitions = new LinkedHashSet();
            context.put(RESOLVING_TARGET_PLATFORM_DEFINITIONS, targetDefinitions);
        }
        return targetDefinitions;
    }
}

