/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.oomph.setup.LicenseInfo;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicensePrePrompter
extends AbstractSetupDialog {
    private static final String DEFAULT_LICENSE_UUID = "DEFAULT_LICENSE";
    private static final String DEFAULT_LICENSE_NAME = "Eclipse Foundation Software User Agreement";
    private static final Set<String> IMPLIED_LICENSE_UUIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("6a3d083ad2bd7d3a80ee293235f8c5b1", "abc76a6cc9d06e4684ff61ed74a972c")));
    private final String license;
    private Browser licenseBrowser;
    private String shellText;

    public LicensePrePrompter(Shell parentShell, String license) {
        super(parentShell, DEFAULT_LICENSE_NAME, 700, 700, SetupUIPlugin.INSTANCE, false);
        this.license = license;
        this.shellText = parentShell.getText();
    }

    protected String getDefaultMessage() {
        return "Applicable licenses will be discovered and prompted later in the installation process.\nAvoid such interruptions by accepting the most common license now.";
    }

    protected void createUI(Composite parent) {
        this.licenseBrowser = new Browser(parent, 0);
        this.licenseBrowser.setLayoutData((Object)new GridData(1808));
        this.licenseBrowser.setBackground(parent.getDisplay().getSystemColor(25));
        this.licenseBrowser.setText(this.license);
        this.licenseBrowser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String url = event.location;
                if (!"about:blank".equals(url)) {
                    OS.INSTANCE.openSystemBrowser(url);
                    event.doit = false;
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Accept Now", true);
        this.createButton(parent, 1, "Decide Later", false);
    }

    public static EList<LicenseInfo> execute(Shell shell, User user) {
        HashSet<String> unacceptedLicenses = new HashSet<String>(IMPLIED_LICENSE_UUIDS);
        for (LicenseInfo licenseInfo : user.getAcceptedLicenses()) {
            String uuid = licenseInfo.getUUID();
            if (DEFAULT_LICENSE_UUID.equals(uuid)) {
                return null;
            }
            unacceptedLicenses.remove(uuid);
        }
        if (unacceptedLicenses.isEmpty()) {
            return null;
        }
        String license = LicensePrePrompter.readLicense();
        if (StringUtil.isEmpty((String)license)) {
            return null;
        }
        BasicEList acceptedLicenses = new BasicEList();
        acceptedLicenses.add((Object)new LicenseInfo(DEFAULT_LICENSE_UUID, "Marker to remember license pre-prompting"));
        LicensePrePrompter prompter = new LicensePrePrompter(shell, license);
        if (prompter.open() == 0) {
            for (String uuid : unacceptedLicenses) {
                acceptedLicenses.add((Object)new LicenseInfo(uuid, DEFAULT_LICENSE_NAME));
            }
        }
        return acceptedLicenses;
    }

    private static String readLicense() {
        StringBuilder builder;
        block7: {
            builder = new StringBuilder();
            InputStream in = null;
            try {
                try {
                    String line;
                    String path = String.valueOf(LicensePrePrompter.class.getPackage().getName().replace('.', '/')) + "/license.html";
                    in = LicensePrePrompter.class.getClassLoader().getResourceAsStream(path);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        if (builder.length() != 0) {
                            builder.append(StringUtil.NL);
                        }
                        builder.append(line);
                    }
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                    IOUtil.close(in);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close((Closeable)in);
        }
        return builder.toString();
    }

    protected String getShellText() {
        return this.shellText;
    }
}

