/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class Descriptors {
    private static final String DISPOSE_LIST = "Descriptors.disposeList";
    private static DisposeListener disposeListener = e -> Descriptors.doDispose(e.widget);

    private Descriptors() {
    }

    public static void setImage(Item item, ImageDescriptor descriptor) {
        Descriptors.callMethod((Widget)item, "setImage", (DeviceResourceDescriptor)descriptor, Image.class);
    }

    public static void setHotImage(ToolItem item, ImageDescriptor descriptor) {
        Descriptors.callMethod((Widget)item, "setHotImage", (DeviceResourceDescriptor)descriptor, Image.class);
    }

    public static void setDisabledImage(ToolItem item, ImageDescriptor descriptor) {
        Descriptors.callMethod((Widget)item, "setDisabledImage", (DeviceResourceDescriptor)descriptor, Image.class);
    }

    public static void setFont(TableItem item, FontDescriptor descriptor) {
        Descriptors.callMethod((Widget)item, "setFont", (DeviceResourceDescriptor)descriptor, Font.class);
    }

    public static void setBackground(TableItem item, ColorDescriptor descriptor) {
        Descriptors.callMethod((Widget)item, "setBackground", (DeviceResourceDescriptor)descriptor, Color.class);
    }

    public static void setForeground(TableItem item, ColorDescriptor descriptor) {
        Descriptors.callMethod((Widget)item, "setForeground", (DeviceResourceDescriptor)descriptor, Color.class);
    }

    public static void setBackground(Control control, ColorDescriptor descriptor) {
        Descriptors.callMethod((Widget)control, "setBackground", (DeviceResourceDescriptor)descriptor, Color.class);
    }

    public static void setForeground(Control control, ColorDescriptor descriptor) {
        Descriptors.callMethod((Widget)control, "setForeground", (DeviceResourceDescriptor)descriptor, Color.class);
    }

    public static void setImage(Button button, ImageDescriptor descriptor) {
        Descriptors.callMethod((Widget)button, "setImage", (DeviceResourceDescriptor)descriptor, Image.class);
    }

    public static void setImage(Label label, ImageDescriptor descriptor) {
        Descriptors.callMethod((Widget)label, "setImage", (DeviceResourceDescriptor)descriptor, Image.class);
    }

    private static ResourceMethod getResourceMethod(Widget toCall, String methodName, Class<?> resourceType) throws NoSuchMethodException {
        ArrayList<ResourceMethod> oldData = toCall.getData(DISPOSE_LIST);
        if (oldData instanceof List) {
            for (Object element : (List)oldData) {
                ResourceMethod method = (ResourceMethod)element;
                if (method.id != methodName) continue;
                return method;
            }
        }
        if (oldData instanceof ResourceMethod) {
            if (((ResourceMethod)((Object)oldData)).id == methodName) {
                return (ResourceMethod)((Object)oldData);
            }
            ArrayList<ResourceMethod> newList = new ArrayList<ResourceMethod>();
            newList.add((ResourceMethod)((Object)oldData));
            oldData = newList;
            toCall.setData(DISPOSE_LIST, oldData);
        }
        Class<?> clazz = toCall.getClass();
        Method method = clazz.getMethod(methodName, resourceType);
        ResourceMethod result = new ResourceMethod(method, methodName);
        if (oldData == null) {
            toCall.setData(DISPOSE_LIST, (Object)result);
            toCall.addDisposeListener(disposeListener);
        } else {
            ((List)oldData).add(result);
        }
        return result;
    }

    private static void callMethod(Widget toCall, String methodName, DeviceResourceDescriptor descriptor, Class<?> resourceType) {
        ResourceMethod method;
        try {
            method = Descriptors.getResourceMethod(toCall, methodName, resourceType);
        }
        catch (NoSuchMethodException e) {
            WorkbenchPlugin.log(e);
            return;
        }
        method.invoke(toCall, descriptor);
    }

    private static void doDispose(Widget widget) {
        Object oldData = widget.getData(DISPOSE_LIST);
        if (oldData instanceof ArrayList) {
            ResourceMethod[] data;
            ArrayList list = (ArrayList)oldData;
            ResourceMethod[] resourceMethodArray = data = list.toArray(new ResourceMethod[list.size()]);
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceMethod method = resourceMethodArray[n2];
                method.dispose();
                ++n2;
            }
        }
        if (oldData instanceof ResourceMethod) {
            ((ResourceMethod)oldData).dispose();
        }
    }

    private static final class ResourceMethod {
        Method method;
        DeviceResourceDescriptor oldDescriptor;
        String id;

        ResourceMethod(Method m, String id) {
            this.method = m;
            this.id = id;
        }

        public void invoke(Widget toCall, DeviceResourceDescriptor newDescriptor) {
            Object newResource;
            if (newDescriptor == this.oldDescriptor) {
                return;
            }
            ResourceManager mgr = JFaceResources.getResources((Display)toCall.getDisplay());
            try {
                newResource = newDescriptor == null ? null : mgr.create(newDescriptor);
            }
            catch (DeviceResourceException e1) {
                WorkbenchPlugin.log(e1);
                return;
            }
            try {
                this.method.invoke((Object)toCall, newResource);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                WorkbenchPlugin.log(e);
                return;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                WorkbenchPlugin.log(e);
                return;
            }
            if (this.oldDescriptor != null) {
                mgr.destroy(this.oldDescriptor);
            }
            this.oldDescriptor = newDescriptor;
        }

        public void dispose() {
            if (this.oldDescriptor != null) {
                ResourceManager mgr = JFaceResources.getResources();
                mgr.destroy(this.oldDescriptor);
                this.oldDescriptor = null;
            }
        }
    }
}

