/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.impl.Messages;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesURIHandlerImpl
extends URIHandlerImpl {
    private static final IEclipsePreferences ROOT = Platform.getPreferencesService().getRootNode();

    public boolean canHandle(URI uri) {
        return "preference".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        if (uri.segmentCount() == 1) {
            class PreferencesInput
            extends InputStream
            implements URIConverter.Loadable {
                private PreferenceNode preferencesNode;
                private InputStream in;

                PreferencesInput(Map map) {
                    this.preferencesNode = PreferencesUtil.getRootPreferenceNode(Boolean.TRUE.equals(map.get("SYNCHRONIZED_PREFERENCES")));
                }

                public void loadResource(Resource resource) throws IOException {
                    resource.getContents().add((Object)this.preferencesNode);
                }

                public int read() throws IOException {
                    if (this.in == null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        this.preferencesNode.eResource().save((OutputStream)out, null);
                        this.in = new ByteArrayInputStream(out.toByteArray());
                    }
                    return this.in.read();
                }
            }
            return new PreferencesInput(options);
        }
        URI preferencePath = uri.trimSegments(1);
        String value = new PreferenceAccessor(preferencePath).get();
        if (value == null) {
            throw new IOException("No preference value available for " + preferencePath);
        }
        return new URIConverter.ReadableInputStream(value);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        if (uri.segmentCount() == 1) {
            class PreferencesOutput
            extends OutputStream
            implements URIConverter.Saveable {
                private final /* synthetic */ URI val$uri;

                PreferencesOutput(URI uRI) {
                    this.val$uri = uRI;
                }

                public void saveResource(Resource resource) throws IOException {
                    EcoreUtil.Copier copier = new EcoreUtil.Copier(){
                        private static final long serialVersionUID = 1L;

                        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
                            if (eAttribute == PreferencesPackage.Literals.PROPERTY__VALUE) {
                                Property property = (Property)eObject;
                                Property copyProperty = (Property)copyEObject;
                                copyProperty.setValue(property.getSecureValue());
                            } else {
                                super.copyAttribute(eAttribute, eObject, copyEObject);
                            }
                        }
                    };
                    PreferenceNode root = (PreferenceNode)copier.copy((EObject)resource.getContents().get(0));
                    copier.copyReferences();
                    Throwable throwable = null;
                    try {
                        Collection<? extends IEclipsePreferences> flush = PreferencesUtil.reconcile(root);
                        for (IEclipsePreferences iEclipsePreferences : flush) {
                            try {
                                iEclipsePreferences.flush();
                            }
                            catch (Throwable ex) {
                                throwable = ex;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        IOException iOException = new IOException(ex.getMessage());
                        iOException.initCause(ex);
                        throw iOException;
                    }
                    if (throwable != null) {
                        IOException ioException = new IOException(throwable.getMessage());
                        ioException.initCause(throwable);
                        throw ioException;
                    }
                }

                public void write(int b) throws IOException {
                    throw new IOException(NLS.bind((String)Messages.PreferencesURIHandlerImpl_UnsupportedStreaming_exception, (Object)this.val$uri));
                }
            }
            return new PreferencesOutput(uri);
        }
        final PreferenceAccessor accessor = new PreferenceAccessor(uri.trimSegments(1));
        return new URIConverter.WriteableOutputStream((Writer)new StringWriter(){

            public void close() throws IOException {
                super.close();
                accessor.put(this.toString());
            }
        }, "UTF-8");
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        new PreferenceAccessor(uri.trimSegments(1)).remove();
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        try {
            return new PreferenceAccessor(uri.trimSegments(1)).get() != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return Collections.emptyMap();
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }

    protected static class PreferenceAccessor {
        private final Preferences preferences;
        private final ISecurePreferences securePreferences;
        private final String key;
        private final boolean isEncrypted;

        public PreferenceAccessor(URI uri) {
            String[] segments = uri.segments();
            int last = segments.length - 1;
            if ("secure".equals(segments[0])) {
                ISecurePreferences node = PreferencesUtil.getSecurePreferences();
                int i = 1;
                while (i < last) {
                    node = node.node(segments[i]);
                    ++i;
                }
                this.preferences = null;
                this.securePreferences = node;
                this.isEncrypted = !"encrypted=false".equals(uri.query());
            } else {
                IEclipsePreferences node = ROOT;
                int i = 0;
                while (i < last) {
                    node = node.node(segments[i]);
                    ++i;
                }
                this.preferences = node;
                this.securePreferences = null;
                this.isEncrypted = false;
            }
            this.key = segments[last];
        }

        public String get() throws IOException {
            try {
                return this.securePreferences == null ? this.preferences.get(this.key, null) : this.securePreferences.get(this.key, null);
            }
            catch (StorageException ex) {
                throw new IOExceptionWithCause((Throwable)ex);
            }
        }

        public void put(String value) throws IOException {
            if (this.securePreferences == null) {
                this.preferences.put(this.key, value);
            } else {
                try {
                    boolean encrypt = this.isEncrypted;
                    String[] stringArray = this.securePreferences.keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        if (key.equals(this.key)) {
                            encrypt = this.securePreferences.isEncrypted(key);
                            break;
                        }
                        ++n2;
                    }
                    this.securePreferences.put(this.key, value, encrypt);
                }
                catch (StorageException ex) {
                    throw new IOExceptionWithCause((Throwable)ex);
                }
            }
            this.flush();
        }

        public void remove() throws IOException {
            if (this.securePreferences == null) {
                this.preferences.remove(this.key);
            } else {
                this.securePreferences.remove(this.key);
            }
            this.flush();
        }

        private void flush() throws IOException {
            try {
                if (this.securePreferences == null) {
                    this.preferences.flush();
                } else {
                    this.securePreferences.flush();
                }
            }
            catch (BackingStoreException ex) {
                throw new IOExceptionWithCause((Throwable)ex);
            }
        }
    }
}

