/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.celleditor;

import org.eclipse.emf.common.ui.celleditor.BasicTableEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class MultiColumnTableEditor
extends BasicTableEditor
implements KeyListener,
MouseListener,
SelectionListener {
    protected TableCursor cursor;
    protected int editableColumns;

    public MultiColumnTableEditor(Table table) {
        this(table, -1);
    }

    public MultiColumnTableEditor(Table table, int editableColumns) {
        super(table);
        this.editableColumns = editableColumns;
        table.addSelectionListener((SelectionListener)this);
        this.cursor = new TableCursor(table, 0);
        this.cursor.addSelectionListener((SelectionListener)this);
        this.cursor.addMouseListener((MouseListener)this);
        if ((table.getStyle() & 0x20) != 0) {
            this.cursor.addKeyListener((KeyListener)this);
        }
    }

    public void dispose() {
        if (this.table != null) {
            this.table.removeSelectionListener((SelectionListener)this);
            this.table = null;
        }
        if (this.cursor != null) {
            this.cursor.removeKeyListener((KeyListener)this);
            this.cursor.removeMouseListener((MouseListener)this);
            this.cursor.removeSelectionListener((SelectionListener)this);
            this.cursor = null;
        }
    }

    public void keyPressed(KeyEvent e) {
        TableItem item;
        if (e.character == ' ' && (item = this.getSelection()) != null) {
            item.setChecked(!item.getChecked());
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Point size = this.cursor.getSize();
        if (e.x >= 0 && e.x < size.x && e.y >= 0 && e.y < size.y) {
            this.edit(this.cursor.getRow(), this.cursor.getColumn());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.cursor) {
            this.table.setSelection(this.cursor.getRow());
        }
        if (e.widget == this.table && this.cursor.getRow() == null) {
            TableItem item = this.getSelection();
            if (item != null) {
                this.cursor.setSelection(item, 0);
            }
            this.cursor.setFocus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        TableItem item;
        if (e.widget == this.cursor && (item = this.getSelection()) != null) {
            this.edit(item, this.cursor.getColumn());
        }
    }

    protected void edit(TableItem item, int column) {
        if (this.canEdit(item, column)) {
            this.cursor.setVisible(false);
            super.edit(item, column);
        }
    }

    protected boolean canEdit(TableItem item, int column) {
        return (1 << column & this.editableColumns) != 0;
    }

    protected void endEditing(TableItem item, int column, Control editor, boolean accept) {
        super.endEditing(item, column, editor, accept);
        this.cursor.setVisible(true);
        this.cursor.setFocus();
    }
}

