/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.BundleManifest;
import org.eclipse.update.internal.configurator.Configuration;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.FeatureParser;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.PluginParser;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SiteEntry
implements IPlatformConfiguration.ISiteEntry,
IConfigurationConstants {
    private static final String MAC_OS_MARKER = ".DS_Store";
    private URL url;
    private URL resolvedURL;
    private IPlatformConfiguration.ISitePolicy policy;
    private boolean updateable = true;
    private Map<String, IPlatformConfiguration.IFeatureEntry> featureEntries;
    private ArrayList<PluginEntry> pluginEntries;
    private long changeStamp;
    private long featuresChangeStamp;
    private long pluginsChangeStamp;
    private String linkFileName;
    private boolean enabled = true;
    private Configuration config;
    private static FeatureParser featureParser = new FeatureParser();
    private static PluginParser pluginParser = new PluginParser();
    private static boolean isMacOS = Utils.getOS().equals("macosx");

    public SiteEntry(URL url) {
        this(url, null);
    }

    public SiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy) {
        if (url == null) {
            try {
                url = new URL("platform:/base/");
            }
            catch (MalformedURLException malformedURLException) {
                url = PlatformConfiguration.getInstallURL();
            }
        }
        if (policy == null) {
            policy = new SitePolicy(PlatformConfiguration.getDefaultPolicy(), DEFAULT_POLICY_LIST);
        }
        if (url.getProtocol().equals("file")) {
            try {
                this.url = new File(url.getFile()).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                this.url = url;
            }
        } else {
            this.url = url;
        }
        this.policy = policy;
        this.resolvedURL = this.url;
    }

    public void setConfig(Configuration config) {
        this.config = config;
        if (this.url.getProtocol().equals("platform")) {
            try {
                if (this.url.getPath().startsWith("/config")) {
                    URL configURL = config.getURL();
                    URL config_loc = new URL(configURL, "..");
                    this.resolvedURL = PlatformConfiguration.resolvePlatformURL(this.url, config_loc);
                } else {
                    this.resolvedURL = PlatformConfiguration.resolvePlatformURL(this.url, config.getInstallURL());
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public IPlatformConfiguration.ISitePolicy getSitePolicy() {
        return this.policy;
    }

    @Override
    public synchronized void setSitePolicy(IPlatformConfiguration.ISitePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.policy = policy;
    }

    @Override
    public String[] getFeatures() {
        return this.getDetectedFeatures();
    }

    @Override
    public String[] getPlugins() {
        IPlatformConfiguration.ISitePolicy policy = this.getSitePolicy();
        if (policy.getType() == 0) {
            return policy.getList();
        }
        if (policy.getType() == 1) {
            ArrayList<String> detectedPlugins = new ArrayList<String>(Arrays.asList(this.getDetectedPlugins()));
            String[] stringArray = policy.getList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String excludedPlugin = stringArray[n2];
                if (detectedPlugins.contains(excludedPlugin)) {
                    detectedPlugins.remove(excludedPlugin);
                }
                ++n2;
            }
            return detectedPlugins.toArray(new String[0]);
        }
        if (policy.getType() == 2) {
            PluginEntry[] managedPlugins = this.getManagedPlugins();
            String[] managedPluginsURLs = new String[managedPlugins.length];
            int i = 0;
            while (i < managedPlugins.length) {
                managedPluginsURLs[i] = managedPlugins[i].getURL();
                ++i;
            }
            return managedPluginsURLs;
        }
        return new String[0];
    }

    private PluginEntry[] getManagedPlugins() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        HashMap<VersionedIdentifier, PluginEntry> cachedPlugins = new HashMap<VersionedIdentifier, PluginEntry>(this.pluginEntries.size());
        for (PluginEntry p : this.pluginEntries) {
            cachedPlugins.put(p.getVersionedIdentifier(), p);
        }
        ArrayList<PluginEntry> managedPlugins = new ArrayList<PluginEntry>();
        for (IPlatformConfiguration.IFeatureEntry feature : this.featureEntries.values()) {
            if (!(feature instanceof FeatureEntry)) continue;
            PluginEntry[] pluginEntryArray = ((FeatureEntry)feature).getPluginEntries();
            int n = pluginEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginEntry plugin = pluginEntryArray[n2];
                if (cachedPlugins.containsKey(plugin.getVersionedIdentifier())) {
                    managedPlugins.add((PluginEntry)cachedPlugins.get(plugin.getVersionedIdentifier()));
                }
                ++n2;
            }
        }
        return managedPlugins.toArray(new PluginEntry[managedPlugins.size()]);
    }

    public PluginEntry[] getPluginEntries() {
        String[] pluginURLs = this.getPlugins();
        HashMap<String, String> map = new HashMap<String, String>(pluginURLs.length);
        String[] stringArray = pluginURLs;
        int n = pluginURLs.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginURL = stringArray[n2];
            map.put(pluginURL, pluginURL);
            ++n2;
        }
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        ArrayList<PluginEntry> plugins = new ArrayList<PluginEntry>(pluginURLs.length);
        int i = 0;
        while (i < this.pluginEntries.size()) {
            PluginEntry p = this.pluginEntries.get(i);
            if (map.containsKey(p.getURL())) {
                plugins.add(p);
            }
            ++i;
        }
        return plugins.toArray(new PluginEntry[plugins.size()]);
    }

    @Override
    public long getChangeStamp() {
        if (this.changeStamp == 0L) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    @Override
    public long getFeaturesChangeStamp() {
        if (this.featuresChangeStamp == 0L) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    @Override
    public long getPluginsChangeStamp() {
        if (this.pluginsChangeStamp == 0L) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    @Override
    public boolean isNativelyLinked() {
        return this.isExternallyLinkedSite();
    }

    public URL getResolvedURL() {
        return this.resolvedURL;
    }

    private void detectFeatures() {
        if (this.featureEntries != null) {
            this.validateFeatureEntries();
        } else {
            this.featureEntries = new HashMap<String, IPlatformConfiguration.IFeatureEntry>();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            return;
        }
        File siteRoot = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File featuresDir = new File(siteRoot, "features");
        if (featuresDir.exists()) {
            File[] dirs;
            File[] fileArray = dirs = featuresDir.listFiles(f -> {
                boolean valid;
                if (isMacOS && f.getName().equals(MAC_OS_MARKER)) {
                    return false;
                }
                boolean bl = valid = f.isDirectory() && new File(f, "feature.xml").exists();
                if (!valid) {
                    Utils.log(NLS.bind((String)Messages.SiteEntry_cannotFindFeatureInDir, (Object[])new String[]{f.getAbsolutePath()}));
                }
                return valid;
            });
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                try {
                    URL featureURL;
                    FeatureEntry featureEntry;
                    File featureXML = new File(dir, "feature.xml");
                    if ((featureXML.lastModified() > this.featuresChangeStamp || dir.lastModified() > this.featuresChangeStamp) && (featureEntry = featureParser.parse(featureURL = featureXML.toURL())) != null) {
                        this.addFeatureEntry(featureEntry);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Utils.log(NLS.bind((String)Messages.InstalledSiteParser_UnableToCreateURLForFile, (Object[])new String[]{featuresDir.getAbsolutePath()}));
                }
                ++n2;
            }
        }
        Utils.debug(this.resolvedURL.toString() + " located  " + this.featureEntries.size() + " feature(s)");
    }

    private void detectPlugins() {
        boolean compareTimeStamps = false;
        if (this.pluginEntries != null) {
            this.validatePluginEntries();
            compareTimeStamps = true;
        } else {
            this.pluginEntries = new ArrayList();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            return;
        }
        File pluginsDir = new File(this.resolvedURL.getFile(), "plugins");
        if (pluginsDir.exists() && pluginsDir.isDirectory()) {
            File[] fileArray = pluginsDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.detectUnpackedPlugin(file, compareTimeStamps);
                } else if (file.getName().endsWith(".jar")) {
                    this.detectPackedPlugin(file, compareTimeStamps);
                }
                ++n2;
            }
        }
        Utils.debug(this.resolvedURL.toString() + " located  " + this.pluginEntries.size() + " plugin(s)");
    }

    /*
     * Exception decompiling
     */
    private void detectPackedPlugin(File file, boolean compareTimeStamps) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void detectUnpackedPlugin(File file, boolean compareTimeStamps) {
        long dirTimestamp = file.lastModified();
        File pluginFile = new File(file, "META-INF/MANIFEST.MF");
        try {
            BundleManifest bundleManifest = new BundleManifest(pluginFile);
            if (bundleManifest.exists()) {
                if (compareTimeStamps && dirTimestamp <= this.pluginsChangeStamp && pluginFile.lastModified() <= this.pluginsChangeStamp) {
                    return;
                }
                PluginEntry entry = bundleManifest.getPluginEntry();
                this.addPluginEntry(entry);
            } else {
                pluginFile = new File(file, "plugin.xml");
                if (!pluginFile.exists()) {
                    pluginFile = new File(file, "fragment.xml");
                }
                if (pluginFile.exists() && !pluginFile.isDirectory()) {
                    if (compareTimeStamps && dirTimestamp <= this.pluginsChangeStamp && pluginFile.lastModified() <= this.pluginsChangeStamp) {
                        return;
                    }
                    PluginEntry entry = pluginParser.parse(pluginFile);
                    this.addPluginEntry(entry);
                }
            }
        }
        catch (IOException e) {
            String pluginFileString = pluginFile.getAbsolutePath();
            if (ConfigurationActivator.DEBUG) {
                Utils.log(Utils.newStatus(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{pluginFileString}), e));
            } else {
                Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorAccessing, (Object[])new String[]{pluginFileString}));
            }
        }
        catch (SAXException sAXException) {
            String pluginFileString = pluginFile.getAbsolutePath();
            Utils.log(NLS.bind((String)Messages.InstalledSiteParser_ErrorParsingFile, (Object[])new String[]{pluginFileString}));
        }
    }

    private synchronized String[] getDetectedFeatures() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        String[] features = new String[this.featureEntries.size()];
        Iterator<IPlatformConfiguration.IFeatureEntry> iterator = this.featureEntries.values().iterator();
        int i = 0;
        while (i < features.length) {
            features[i] = ((FeatureEntry)iterator.next()).getURL();
            ++i;
        }
        return features;
    }

    private synchronized String[] getDetectedPlugins() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        String[] plugins = new String[this.pluginEntries.size()];
        int i = 0;
        while (i < plugins.length) {
            plugins[i] = this.pluginEntries.get(i).getURL();
            ++i;
        }
        return plugins;
    }

    private void computeChangeStamp() {
        this.changeStamp = Math.max(this.computeFeaturesChangeStamp(), this.computePluginsChangeStamp());
    }

    private synchronized long computeFeaturesChangeStamp() {
        if (this.featuresChangeStamp > 0L) {
            return this.featuresChangeStamp;
        }
        long start = 0L;
        if (ConfigurationActivator.DEBUG) {
            start = new Date().getTime();
        }
        String[] features = this.getFeatures();
        long dirStamp = 0L;
        if (PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            File featuresDir = new File(root, "features");
            dirStamp = featuresDir.lastModified();
        }
        this.featuresChangeStamp = Math.max(dirStamp, this.computeStamp(features));
        if (ConfigurationActivator.DEBUG) {
            long end = new Date().getTime();
            Utils.debug(this.resolvedURL.toString() + " feature stamp: " + this.featuresChangeStamp + " in " + (end - start) + "ms");
        }
        return this.featuresChangeStamp;
    }

    private synchronized long computePluginsChangeStamp() {
        if (this.pluginsChangeStamp > 0L) {
            return this.pluginsChangeStamp;
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            Utils.log(NLS.bind((String)Messages.SiteEntry_computePluginStamp, (Object[])new String[]{this.resolvedURL.toExternalForm()}));
            return 0L;
        }
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File pluginsDir = new File(root, "plugins");
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            Utils.debug(NLS.bind((String)Messages.SiteEntry_pluginsDir, (Object[])new String[]{pluginsDir.getAbsolutePath()}));
            return 0L;
        }
        this.pluginsChangeStamp = pluginsDir.lastModified();
        return this.pluginsChangeStamp;
    }

    private long computeStamp(String[] targets) {
        long result = 0L;
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            String[] stringArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                String target = stringArray[n2];
                result ^= (long)target.hashCode();
                ++n2;
            }
            Utils.debug("*WARNING* computing stamp using URL hashcodes only");
        } else {
            File rootFile = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            if (rootFile.exists()) {
                File f = null;
                String[] stringArray = targets;
                int n = targets.length;
                int n3 = 0;
                while (n3 < n) {
                    String target = stringArray[n3];
                    f = new File(rootFile, target);
                    if (f.exists()) {
                        result = Math.max(result, f.lastModified());
                    }
                    ++n3;
                }
            }
        }
        return result;
    }

    public void setLinkFileName(String linkFileName) {
        this.linkFileName = linkFileName;
    }

    public String getLinkFileName() {
        return this.linkFileName;
    }

    public boolean isExternallyLinkedSite() {
        return this.linkFileName != null && !this.linkFileName.trim().isEmpty();
    }

    public synchronized void refresh() {
        this.featuresChangeStamp = 0L;
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.featureEntries = null;
        this.pluginEntries = null;
    }

    public void refreshPlugins() {
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.pluginEntries = null;
    }

    public void addFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        IPlatformConfiguration.IFeatureEntry existing;
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap<String, IPlatformConfiguration.IFeatureEntry>();
        }
        if ((existing = this.featureEntries.get(feature.getFeatureIdentifier())) != null) {
            VersionedIdentifier existingVersion = new VersionedIdentifier(existing.getFeatureIdentifier(), existing.getFeatureVersion());
            VersionedIdentifier newVersion = new VersionedIdentifier(feature.getFeatureIdentifier(), feature.getFeatureVersion());
            if (existingVersion.getVersion().compareTo(newVersion.getVersion()) < 0) {
                this.featureEntries.put(feature.getFeatureIdentifier(), feature);
                this.pluginsChangeStamp = 0L;
            } else if (existingVersion.equals(newVersion) && feature instanceof FeatureEntry && existing instanceof FeatureEntry && !((FeatureEntry)feature).getURL().equals(((FeatureEntry)existing).getURL())) {
                Utils.log(NLS.bind((String)Messages.SiteEntry_duplicateFeature, (Object[])new String[]{this.getURL().toExternalForm(), existing.getFeatureIdentifier()}));
            }
        } else {
            this.featureEntries.put(feature.getFeatureIdentifier(), feature);
            this.pluginsChangeStamp = 0L;
        }
        if (feature instanceof FeatureEntry) {
            ((FeatureEntry)feature).setSite(this);
        }
    }

    public FeatureEntry[] getFeatureEntries() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        if (this.featureEntries == null) {
            return new FeatureEntry[0];
        }
        return this.featureEntries.values().toArray(new FeatureEntry[this.featureEntries.size()]);
    }

    public void addPluginEntry(PluginEntry plugin) {
        if (this.pluginEntries == null) {
            this.pluginEntries = new ArrayList();
        }
        this.pluginEntries.add(plugin);
    }

    public PluginEntry[] getAllPluginEntries() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        return this.pluginEntries.toArray(new PluginEntry[this.pluginEntries.size()]);
    }

    public void loadFromDisk(long lastChange) throws CoreException {
        this.featuresChangeStamp = lastChange;
        this.pluginsChangeStamp = lastChange;
        this.detectFeatures();
        this.detectPlugins();
    }

    public Element toXML(Document doc) {
        Element siteElement = doc.createElement("site");
        if (this.getURL() != null) {
            URL toPersist = this.config == null || this.config.isTransient() ? this.getURL() : Utils.makeRelative(Utils.getInstallURL(), this.getURL());
            siteElement.setAttribute("url", toPersist.toString());
        }
        siteElement.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        siteElement.setAttribute("updateable", this.isUpdateable() ? "true" : "false");
        if (this.isExternallyLinkedSite()) {
            siteElement.setAttribute("linkfile", this.getLinkFileName().trim().replace(File.separatorChar, '/'));
        }
        int type = this.getSitePolicy().getType();
        String typeString = "UNKNOWN";
        try {
            typeString = CFG_POLICY_TYPE[type];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        siteElement.setAttribute("policy", typeString);
        String[] list = this.getSitePolicy().getList();
        if (list.length > 0) {
            StringBuilder sb = new StringBuilder(256);
            int i = 0;
            while (i < list.length - 1) {
                sb.append(list[i]);
                sb.append(',');
                ++i;
            }
            sb.append(list[list.length - 1]);
            siteElement.setAttribute("list", sb.toString());
        }
        FeatureEntry[] featureEntryArray = this.getFeatureEntries();
        int n = featureEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry feat = featureEntryArray[n2];
            Element featureElement = feat.toXML(doc);
            siteElement.appendChild(featureElement);
            ++n2;
        }
        return siteElement;
    }

    private void validateFeatureEntries() {
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        Iterator<IPlatformConfiguration.IFeatureEntry> iterator = this.featureEntries.values().iterator();
        ArrayList<String> deletedFeatures = new ArrayList<String>();
        while (iterator.hasNext()) {
            FeatureEntry feature = (FeatureEntry)iterator.next();
            File featureXML = new File(root, feature.getURL());
            if (featureXML.exists()) continue;
            deletedFeatures.add(feature.getFeatureIdentifier());
        }
        for (String string : deletedFeatures) {
            this.featureEntries.remove(string);
        }
    }

    private void validatePluginEntries() {
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        ArrayList<PluginEntry> deletedPlugins = new ArrayList<PluginEntry>();
        for (PluginEntry plugin : this.pluginEntries) {
            File pluginLocation = new File(root, plugin.getURL());
            if (pluginLocation.exists()) continue;
            deletedPlugins.add(plugin);
        }
        for (PluginEntry pluginEntry : deletedPlugins) {
            this.pluginEntries.remove(pluginEntry);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public FeatureEntry getFeatureEntry(String id) {
        FeatureEntry[] featureEntryArray = this.getFeatureEntries();
        int n = featureEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry feature = featureEntryArray[n2];
            if (feature.getFeatureIdentifier().equals(id)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    public boolean unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        FeatureEntry existingFeature = this.getFeatureEntry(feature.getFeatureIdentifier());
        if (existingFeature != null) {
            this.featureEntries.remove(existingFeature.getFeatureIdentifier());
        }
        return existingFeature != null;
    }

    public void initialized() {
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap<String, IPlatformConfiguration.IFeatureEntry>();
        }
    }
}

