/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo.ui;

import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.ui.JREComposite;
import org.eclipse.oomph.jreinfo.ui.JREInfoUIPlugin;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.Request;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class JREDialog
extends OomphDialog {
    public static final String TITLE = "Java Virtual Machines";
    private final Request.Handler downloadHandler;
    private JREFilter filter;
    private Object selectedElement;
    private JREComposite composite;

    public JREDialog(Shell parentShell, Request.Handler downloadHandler) {
        super(parentShell, TITLE, 600, 500, (OomphUIPlugin)JREInfoUIPlugin.INSTANCE, false);
        this.downloadHandler = downloadHandler;
        this.setShellStyle(68656);
    }

    public JREFilter getJREFilter() {
        return this.filter;
    }

    public void setJREFilter(JREFilter filter) {
        this.filter = filter;
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                JREDialog.this.setMessage(JREDialog.this.getDefaultMessage());
            }
        });
    }

    public Object getSelectedElement() {
        if (this.composite == null) {
            return this.selectedElement;
        }
        return this.composite.getSelectedElement();
    }

    public void setSelectedElement(Object selectedElement) {
        this.selectedElement = selectedElement;
    }

    public final JREComposite getComposite() {
        return this.composite;
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        String message = "Select a Java ";
        message = this.filter != null ? String.valueOf(message) + this.filter.toString() + "." : String.valueOf(message) + "VM.";
        return message;
    }

    protected String getImagePath() {
        return "library_wiz.png";
    }

    protected int getContainerMargin() {
        return 5;
    }

    protected void createUI(Composite parent) {
        this.getShell().setImage(JREInfoUIPlugin.INSTANCE.getSWTImage("jre"));
        this.composite = new JREComposite(parent, 0, this.downloadHandler, this.filter, this.selectedElement){

            protected void elementChanged(Object element) {
                super.elementChanged(element);
                JREDialog.this.elementChanged(element);
            }

            protected void doubleClicked(JRE jre) {
                JREDialog.this.close();
            }
        };
        this.composite.setLayoutData(new GridData(1808));
    }

    protected void elementChanged(Object element) {
    }
}

