/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import java.net.URI;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Activator;
import org.eclipse.userstorage.internal.CredentialedSession;
import org.eclipse.userstorage.internal.Session;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.AbstractCredentialsProvider;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.ui.internal.CredentialsDialog;
import org.eclipse.userstorage.ui.internal.UIUtil;

public final class DialogCredentialsProvider
extends AbstractCredentialsProvider {
    public static final DialogCredentialsProvider INSTANCE = new DialogCredentialsProvider();
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";

    public Credentials provideCredentials(final IStorageService service, final boolean reauthentication) {
        final Credentials[] credentials = new Credentials[1];
        try {
            final Shell shell = UIUtil.getShell();
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CredentialsDialog dialog = new CredentialsDialog(shell, service, reauthentication);
                    if (dialog.open() == 0) {
                        credentials[0] = dialog.getCredentials();
                    }
                }
            });
        }
        catch (Throwable ex) {
            Activator.log((Throwable)ex);
        }
        return credentials[0];
    }

    public Credentials getCredentials(IStorageService service) {
        ISecurePreferences securePreferences;
        block7: {
            securePreferences = Activator.getSecurePreferences();
            if (securePreferences != null) break block7;
            return null;
        }
        try {
            String serviceNode = StringUtil.encodeURI((URI)service.getServiceURI());
            securePreferences = securePreferences.node(serviceNode);
            if (securePreferences != null) {
                String username = securePreferences.get(USERNAME_KEY, null);
                String password = securePreferences.get(PASSWORD_KEY, null);
                if (StringUtil.isEmpty((String)username)) {
                    username = null;
                }
                if (StringUtil.isEmpty((String)password)) {
                    password = null;
                }
                if (username != null || password != null) {
                    return new Credentials(username, password);
                }
            }
        }
        catch (StorageException ex) {
            DialogCredentialsProvider.logSecureStorageProblem((Exception)((Object)ex));
        }
        return null;
    }

    public boolean updateCredentials(IStorageService service, Credentials credentials) {
        String password;
        String username;
        ISecurePreferences securePreferences;
        block9: {
            block8: {
                try {
                    securePreferences = Activator.getSecurePreferences();
                    if (securePreferences != null) break block8;
                    return false;
                }
                catch (Exception ex) {
                    DialogCredentialsProvider.logSecureStorageProblem(ex);
                    return false;
                }
            }
            String serviceNode = StringUtil.encodeURI((URI)service.getServiceURI());
            securePreferences = securePreferences.node(serviceNode);
            if (securePreferences != null) break block9;
            return false;
        }
        String string = username = credentials == null ? null : credentials.getUsername();
        if (StringUtil.isEmpty((String)username)) {
            securePreferences.remove(USERNAME_KEY);
        } else {
            securePreferences.put(USERNAME_KEY, username, false);
        }
        String string2 = password = credentials == null ? null : credentials.getPassword();
        if (StringUtil.isEmpty((String)password)) {
            securePreferences.remove(PASSWORD_KEY);
        } else {
            securePreferences.put(PASSWORD_KEY, password, true);
        }
        securePreferences.flush();
        return true;
    }

    private static void logSecureStorageProblem(Exception ex) {
        Activator.log((Throwable)ex);
    }

    public Session openSession(IStorageService service) {
        return new CredentialedSession(service, (ICredentialsProvider)this);
    }
}

