/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.service.SecurityService;
import org.eclipse.packagedrone.sec.web.filter.SecurityHttpRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SecurityFilter.class);
    protected static final String ATTR_USER_INFORMATION = String.valueOf(SecurityFilter.class.getName()) + ".userInformation";
    protected static final String ATTR_USER_RELOAD = String.valueOf(SecurityFilter.class.getName()) + ".reload";
    public static final String ATTR_REMEMBER_ME = String.valueOf(SecurityFilter.class.getName()) + ".rememberMe";
    public static final String COOKIE_REMEMBER_ME = "rememberMe";
    public static final String COOKIE_EMAIL = "email";
    private SecurityService service;

    public void setService(SecurityService service) {
        this.service = service;
    }

    public void unsetService(SecurityService service) {
        this.service = null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        logger.trace("doFilter[{}] - {}", (Object)(this.service != null ? 1 : 0), (Object)request);
        if (this.service != null && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            logger.trace("Injecting request wrapper");
            this.processFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        logger.trace("Processing request: {}", (Object)request);
        HttpSession session = request.getSession();
        if (session != null) {
            SecurityFilter.markReloadDetails(session);
            this.tryRememberMe(request, response, session);
        }
        filterChain.doFilter((ServletRequest)new SecurityHttpRequestWrapper(this.service, request), (ServletResponse)response);
    }

    protected void tryRememberMe(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Object userObj = session.getAttribute(ATTR_USER_INFORMATION);
        if (userObj == null) {
            String token = this.findCookie(COOKIE_REMEMBER_ME, request.getCookies());
            String email = this.findCookie(COOKIE_EMAIL, request.getCookies());
            if (token != null && email != null) {
                try {
                    UserInformation user = this.service.login(email, token);
                    logger.info("Tried to log in using rememberMe token: {} -> {} for {}", new Object[]{email, user, request});
                    SecurityFilter.applyUserInformation(request, user);
                }
                catch (Exception e) {
                    logger.info("Failed to login in by 'rember me', deleting cookie", (Throwable)e);
                    Cookie cookie = new Cookie(COOKIE_REMEMBER_ME, token);
                    cookie.setMaxAge(0);
                    response.addCookie(cookie);
                }
            }
        }
    }

    private String findCookie(String name, Cookie[] cookies) {
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(name)) {
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public static void markReloadDetails(HttpSession session) {
        if (session == null) {
            return;
        }
        session.setAttribute(ATTR_USER_RELOAD, (Object)true);
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        return request.getUserPrincipal() != null;
    }

    public static void applyUserInformation(HttpServletRequest request, UserInformation user) {
        HttpSession session = request.getSession();
        session.setAttribute(ATTR_USER_INFORMATION, (Object)user);
        session.removeAttribute(ATTR_USER_RELOAD);
    }
}

