/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.internal.managed;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.repo.signing.pgp.ManagedKey;
import org.eclipse.packagedrone.repo.signing.pgp.ManagedPgpConfiguration;
import org.eclipse.packagedrone.repo.signing.pgp.PgpHelper;
import org.eclipse.packagedrone.repo.signing.pgp.internal.managed.Configuration;
import org.eclipse.packagedrone.repo.signing.pgp.internal.managed.ManagedPgpConfigurationImpl;
import org.eclipse.packagedrone.repo.signing.pgp.internal.managed.ManagedSigningService;
import org.eclipse.packagedrone.utils.Suppressed;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Entry {
    private final Configuration cfg;
    private final List<ServiceRegistration<?>> regs = new LinkedList();
    private final BundleContext context;
    private ManagedPgpConfigurationImpl configuration;

    public Entry(BundleContext context, Configuration cfg) {
        this.context = context;
        this.cfg = cfg;
        this.configuration = new ManagedPgpConfigurationImpl(this.cfg, null, Collections.emptyList());
    }

    public ManagedPgpConfiguration getConfiguration() {
        return this.configuration;
    }

    public Configuration getRawConfiguration() {
        return this.cfg;
    }

    public void start() {
        List<Object> keys = Collections.emptyList();
        Exception error = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Suppressed s = new Suppressed("Failed to load key", Exception::new);){
                keys = this.activate((Suppressed<Exception>)s);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            error = e;
        }
        this.configuration = new ManagedPgpConfigurationImpl(this.cfg, error, Collections.unmodifiableList(keys));
    }

    private List<ManagedKey> activate(Suppressed<Exception> sup) throws Exception {
        LinkedList<ManagedKey> keys = new LinkedList<ManagedKey>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<PGPSecretKey> s = PgpHelper.streamSecretKeys(PgpHelper.fromString(this.cfg.getSecretKey())).filter(PGPSecretKey::isSigningKey);){
            s.forEach(key -> sup.run(() -> this.processKey((List<ManagedKey>)keys, (PGPSecretKey)key)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return keys;
    }

    private void processKey(List<ManagedKey> keys, PGPSecretKey key) throws Exception {
        String keyId = String.format("%016X", key.getKeyID());
        Stream<Object> s = StreamSupport.stream(Spliterators.spliteratorUnknownSize(key.getUserIDs(), 16), false);
        List<String> users = s.map(Object::toString).collect(Collectors.toList());
        int bits = key.getPublicKey().getBitStrength();
        ManagedKey mkey = new ManagedKey(keyId, users, !key.isMasterKey(), bits);
        keys.add(mkey);
        this.registerKey(key, users);
    }

    protected void registerKey(PGPSecretKey key, List<String> users) throws Exception {
        String keyId = String.format("%016X", key.getKeyID());
        ManagedSigningService service = new ManagedSigningService(key, this.cfg.getPassphrase());
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put("service.pid", "pgp." + keyId);
        String usersString = users.stream().collect(Collectors.joining("; "));
        if (!users.isEmpty()) {
            ((Dictionary)properties).put("service.description", String.format("Managed PGP key (%s) %s: %s", keyId, !key.isMasterKey() ? "(sub)" : "", usersString));
        } else {
            ((Dictionary)properties).put("service.description", String.format("Managed PGP key (%s) %s", keyId, !key.isMasterKey() ? "(sub)" : ""));
        }
        this.regs.add(this.context.registerService(SigningService.class, (Object)service, properties));
    }

    public void stop() {
        this.regs.forEach(ServiceRegistration::unregister);
        this.regs.clear();
    }
}

