/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether.web;

import com.google.common.collect.HashMultimap;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.packagedrone.job.AbstractJsonJobFactory;
import org.eclipse.packagedrone.job.JobFactoryDescriptor;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.importer.aether.AetherImporter;
import org.eclipse.packagedrone.repo.importer.aether.ImportConfiguration;
import org.eclipse.packagedrone.repo.importer.aether.web.AetherResult;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.scada.utils.io.RecursiveDeleteVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherResolver
extends AbstractJsonJobFactory<ImportConfiguration, AetherResult> {
    private static final Logger logger = LoggerFactory.getLogger(AetherResolver.class);
    public static final String ID = "org.eclipse.packagedrone.repo.importer.aether.web.resolver";
    private static final JobFactoryDescriptor DESCRIPTOR = new JobFactoryDescriptor(){

        public LinkTarget getResultTarget() {
            return null;
        }
    };
    private static final MetaKey KEY_GROUP_ID = new MetaKey("mvn", "groupId");
    private static final MetaKey KEY_ARTIFACT_ID = new MetaKey("mvn", "artifactId");
    private static final MetaKey KEY_CLASSIFIER = new MetaKey("mvn", "classifier");
    private static final MetaKey KEY_EXTENSION = new MetaKey("mvn", "extension");
    private static final MetaKey KEY_VERSION = new MetaKey("mvn", "version");
    private ChannelService channelService;

    public AetherResolver() {
        super(ImportConfiguration.class);
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    protected String makeLabelFromData(ImportConfiguration data) {
        String label = "";
        if (!data.getCoordinates().isEmpty()) {
            label = data.getCoordinates().get(0).toString();
            if (data.getCoordinates().size() > 1) {
                label = String.valueOf(label) + String.format(" (and %s more)", data.getCoordinates().size() - 1);
            }
        }
        return String.format("Resolve maven dependencies: %s", label);
    }

    public JobFactoryDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    protected AetherResult process(JobInstance.Context context, ImportConfiguration cfg) throws Exception {
        Path tmpDir = Files.createTempDirectory("aether", new FileAttribute[0]);
        try {
            AetherResult aetherResult = AetherResolver.markExisting(AetherImporter.prepareDependencies(tmpDir, cfg), cfg, this.channelService);
            return aetherResult;
        }
        catch (Exception e) {
            logger.warn("Failed to test", (Throwable)e);
            throw e;
        }
        finally {
            Files.walkFileTree(tmpDir, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
            Files.deleteIfExists(tmpDir);
        }
    }

    private static AetherResult markExisting(AetherResult result, ImportConfiguration cfg, ChannelService channelService) {
        String channelId = cfg.getValidationChannelId();
        if (channelId == null || channelId.isEmpty()) {
            return result;
        }
        try {
            channelService.accessRun(ChannelService.By.id((String)cfg.getValidationChannelId()), ReadableChannel.class, channel -> AetherResolver.markExisting(result, channel));
        }
        catch (ChannelNotFoundException channelNotFoundException) {}
        return result;
    }

    private static void markExisting(AetherResult result, ReadableChannel channel) {
        HashMultimap existing = HashMultimap.create();
        for (ArtifactInformation ai : channel.getArtifacts()) {
            String groupId = (String)ai.getMetaData().get(KEY_GROUP_ID);
            String artifactId = (String)ai.getMetaData().get(KEY_ARTIFACT_ID);
            String classifier = (String)ai.getMetaData().get(KEY_CLASSIFIER);
            String extension = (String)ai.getMetaData().get(KEY_EXTENSION);
            String version = (String)ai.getMetaData().get(KEY_VERSION);
            if (groupId == null || artifactId == null || version == null) continue;
            String key = AetherResolver.makeExistingKey(groupId, artifactId, classifier, extension);
            existing.put((Object)key, (Object)version);
        }
        for (AetherResult.Entry entry : result.getArtifacts()) {
            String key = AetherResolver.makeExistingKey(entry.getCoordinates().getGroupId(), entry.getCoordinates().getArtifactId(), entry.getCoordinates().getClassifier(), entry.getCoordinates().getExtension());
            entry.getExistingVersions().addAll(existing.get((Object)key));
        }
    }

    private static String makeExistingKey(String groupId, String artifactId, String classifier, String extension) {
        StringBuilder sb = new StringBuilder();
        sb.append(groupId);
        sb.append(':').append(artifactId);
        if (classifier != null && !classifier.isEmpty()) {
            sb.append(':').append(classifier);
        }
        if (extension != null && !extension.isEmpty()) {
            sb.append(':').append(extension);
        }
        return sb.toString();
    }
}

