/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.eclipse.packagedrone.utils.converter.Converter;
import org.eclipse.packagedrone.utils.converter.JSON;

public class StringToJsonConverter
implements Converter {
    public static final StringToJsonConverter INSTANCE = new StringToJsonConverter();

    @Override
    public boolean canConvert(Class<?> from, Class<?> to) {
        boolean isJson = to.isAnnotationPresent(JSON.class);
        return from.equals(String.class) && isJson;
    }

    @Override
    public Object convertTo(Object value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        String val = (String)value;
        Gson gson = new GsonBuilder().create();
        return gson.fromJson(val, clazz);
    }
}

