/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.packagedrone.repo.XmlHelper;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.AbstractDocumentProcessor;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.DocumentCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class AbstractRepositoryProcessor
extends AbstractDocumentProcessor {
    private final XmlHelper xml = new XmlHelper();
    protected final Map<String, String> properties = new HashMap<String, String>();
    private final boolean compressed;
    private final String title;
    private final String basename;

    public AbstractRepositoryProcessor(String title, String basename, boolean compressed, DocumentCache cache, Map<String, String> additionalProperties) {
        super(cache);
        this.title = title;
        this.compressed = compressed;
        this.basename = basename;
        this.properties.putAll(additionalProperties);
        this.properties.put("p2.timestamp", "" + System.currentTimeMillis());
        if (compressed) {
            this.properties.put("p2.compressed", "true");
        }
    }

    @Override
    public String getId() {
        return String.valueOf(this.basename) + (this.compressed ? ".jar" : ".xml");
    }

    @Override
    public String getMimeType() {
        return this.compressed ? "application/zip" : "application/xml";
    }

    protected void addProperties(Element root) {
        Element props = XmlHelper.addElement((Element)root, (String)"properties");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            Element p = XmlHelper.addElement((Element)props, (String)"property");
            p.setAttribute("name", entry.getKey());
            p.setAttribute("value", entry.getValue());
        }
        XmlHelper.fixSize((Element)props);
    }

    protected Document initRepository(String processingType, String type) {
        Document doc = this.xml.create();
        ProcessingInstruction pi = doc.createProcessingInstruction(processingType, "version=\"1.1.0\"");
        doc.appendChild(pi);
        Element root = doc.createElement("repository");
        doc.appendChild(root);
        root.setAttribute("name", this.title);
        root.setAttribute("type", type);
        root.setAttribute("version", "1");
        return doc;
    }

    public void write(Document doc, OutputStream stream) throws IOException {
        if (this.compressed) {
            ZipOutputStream zos = new ZipOutputStream(stream);
            zos.putNextEntry(new ZipEntry(String.valueOf(this.basename) + ".xml"));
            this.writeDoc(doc, zos);
            zos.closeEntry();
            zos.finish();
        } else {
            this.writeDoc(doc, stream);
        }
    }

    protected void writeDoc(Document doc, OutputStream stream) {
        try {
            this.xml.write((Node)doc, stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

