/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ServletWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultServletMapping;
import org.ops4j.pax.web.utils.ServletAnnotationScanner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletTracker<T extends Servlet>
extends AbstractTracker<T, ServletWebElement> {
    private static final Logger LOG = LoggerFactory.getLogger(ServletTracker.class);

    private ServletTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext);
    }

    public static <T extends Servlet> ServiceTracker<T, ServletWebElement> createTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        return new ServletTracker<T>(extenderContext, bundleContext).create(Servlet.class, HttpServlet.class);
    }

    @Override
    ServletWebElement createWebElement(ServiceReference<T> serviceReference, T published) {
        Object httpContextId;
        Object alias = serviceReference.getProperty("alias");
        String[] urlPatternsProp = serviceReference.getProperty("urlPatterns");
        String[] initParamKeys = serviceReference.getPropertyKeys();
        String initPrefixProp = (String)serviceReference.getProperty("init-prefix");
        if (initPrefixProp == null) {
            initPrefixProp = "init.";
        }
        Object servletName = serviceReference.getProperty("servlet-name");
        ServletAnnotationScanner annotationScan = new ServletAnnotationScanner(published.getClass());
        if (annotationScan.scanned.booleanValue()) {
            if (urlPatternsProp == null) {
                urlPatternsProp = annotationScan.urlPatterns;
            } else {
                HashSet<String> patterns = new HashSet<String>();
                patterns.addAll(Arrays.asList(annotationScan.urlPatterns));
                if (urlPatternsProp instanceof String && ((String)urlPatternsProp).trim().length() != 0) {
                    patterns.add((String)urlPatternsProp);
                } else if (urlPatternsProp instanceof String[]) {
                    patterns.addAll(Arrays.asList(urlPatternsProp));
                }
                urlPatternsProp = patterns.toArray(new String[patterns.size()]);
            }
        }
        if (!(servletName == null || servletName instanceof String && servletName.toString().trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid servlet-name property.");
            return null;
        }
        if (alias != null && urlPatternsProp != null) {
            LOG.warn("Registered servlet [" + published + "] cannot have both alias and url patterns");
            return null;
        }
        if (alias == null && urlPatternsProp == null) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid alias or url patterns property");
            return null;
        }
        if (!(alias == null || alias instanceof String && ((String)alias).trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid alias property");
            return null;
        }
        String[] urlPatterns = null;
        if (urlPatternsProp != null) {
            if (urlPatternsProp instanceof String && ((String)urlPatternsProp).trim().length() != 0) {
                urlPatterns = new String[]{(String)urlPatternsProp};
            } else if (urlPatternsProp instanceof String[]) {
                urlPatterns = urlPatternsProp;
            } else {
                LOG.warn("Registered servlet [" + published + "] has an invalid url pattern property (must be a non empty String or String[])");
                return null;
            }
        }
        if (!((httpContextId = serviceReference.getProperty("httpContext.id")) == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered servlet [" + published + "] did not contain a valid http context id");
            return null;
        }
        HashMap<String, String> initParams = new HashMap<String, String>();
        Integer loadOnStartup = null;
        Boolean asyncSupported = null;
        for (String string : initParamKeys) {
            try {
                String value = serviceReference.getProperty(string) == null ? "" : serviceReference.getProperty(string).toString();
                if (string.startsWith(initPrefixProp == null ? "" : initPrefixProp)) {
                    initParams.put(string.replaceFirst(initPrefixProp, ""), value);
                }
                if ("load-on-startup".equalsIgnoreCase(string) && value != null) {
                    loadOnStartup = Integer.parseInt(value);
                }
                if (!"async-supported".equalsIgnoreCase(string) || value == null) continue;
                asyncSupported = Boolean.parseBoolean(value);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (annotationScan.scanned.booleanValue()) {
            for (String string : annotationScan.webInitParams) {
                String name = string.name();
                String value = string.value();
                initParams.put(name, value);
            }
        }
        if (annotationScan.scanned.booleanValue() && annotationScan.asyncSupported != null) {
            asyncSupported = annotationScan.asyncSupported;
        }
        if (annotationScan.scanned.booleanValue() && annotationScan.loadOnStartup != null) {
            loadOnStartup = (int)annotationScan.loadOnStartup;
        }
        DefaultServletMapping mapping = new DefaultServletMapping();
        mapping.setHttpContextId((String)httpContextId);
        mapping.setServlet((Servlet)published);
        if (servletName != null) {
            mapping.setServletName(servletName.toString().trim());
        }
        mapping.setAlias((String)alias);
        mapping.setUrlPatterns(urlPatterns);
        mapping.setInitParams(initParams);
        mapping.setLoadOnStartup(loadOnStartup);
        mapping.setAsyncSupported(asyncSupported);
        return new ServletWebElement(mapping);
    }
}

