/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.internal;

import com.google.common.io.CharStreams;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.packagedrone.repo.manage.system.SystemService;

public class SystemServiceImpl
implements SystemService {
    private Server server;
    private final String hostname = SystemServiceImpl.discoverHostname();

    public String getHostname() {
        return this.hostname;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void unsetServer(Server server) {
        if (this.server == null) {
            this.server = null;
        }
    }

    @Override
    public String getDefaultSitePrefix() {
        String prefix = System.getProperty("package.drone.site.prefix");
        if (prefix != null && !prefix.isEmpty()) {
            return prefix;
        }
        prefix = System.getenv("PACKAGE_DRONE_SITE_PREFIX");
        if (prefix != null && !prefix.isEmpty()) {
            return prefix;
        }
        prefix = this.makePrefixFromOsgiProperties();
        if (prefix != null) {
            return prefix;
        }
        return this.makePrefixFromJetty();
    }

    protected String makePrefixFromOsgiProperties() {
        String port = System.getProperty("org.osgi.service.http.port");
        if (port == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(SystemServiceImpl.discoverHostname());
        if (!"80".equals(port)) {
            sb.append(':').append(port);
        }
        return sb.toString();
    }

    @Deprecated
    protected String makePrefixFromJetty() {
        if (this.server == null) {
            return null;
        }
        Connector[] connectorArray = this.server.getConnectors();
        int n = connectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connector c = connectorArray[n2];
            if (c instanceof NetworkConnector) {
                NetworkConnector nc = (NetworkConnector)c;
                StringBuilder sb = new StringBuilder();
                String protocol = "http";
                List protos = nc.getProtocols();
                for (String proto : protos) {
                    if (!proto.startsWith("SSL-")) continue;
                    protocol = "https";
                    break;
                }
                sb.append(protocol).append("://");
                if (nc.getHost() == null) {
                    sb.append(this.hostname);
                } else {
                    sb.append(nc.getHost());
                }
                if (!("http".equals(protocol) && nc.getPort() == 80 || "https".equals(protocol) && nc.getPort() == 443)) {
                    sb.append(':').append(nc.getPort());
                }
                return sb.toString();
            }
            ++n2;
        }
        return null;
    }

    private static String discoverHostname() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname == null) {
            hostname = System.getenv("COMPUTERNAME");
        }
        if (hostname == null) {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (FileReader reader = new FileReader("/etc/hostname");){
                    hostname = CharStreams.toString((Readable)reader).trim();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        }
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (hostname == null) {
            hostname = "localhost";
        }
        return hostname;
    }
}

