/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.channel;

import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.job.JobHandle;
import org.eclipse.packagedrone.job.JobManager;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.web.channel.ImportManager;
import org.eclipse.packagedrone.repo.importer.Importer;
import org.eclipse.packagedrone.repo.importer.ImporterDescription;
import org.eclipse.packagedrone.repo.importer.job.ImporterResult;
import org.eclipse.packagedrone.repo.importer.web.ImportDescriptor;
import org.eclipse.packagedrone.repo.importer.web.ImportRequest;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Secured
@Controller
@ViewResolver(value="/WEB-INF/views/imp/%s.jsp")
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class ImportController
implements InterfaceExtender {
    private ChannelService service;
    private ImportManager impManager;
    private JobManager jobManager;
    private static ImporterDescriptionLabelComparator NAME_COMPARATOR = new ImporterDescriptionLabelComparator();
    private ServiceTracker<Importer, Entry> tracker;
    private final ServiceTrackerCustomizer<Importer, Entry> customizer = new ServiceTrackerCustomizer<Importer, Entry>(){

        public void removedService(ServiceReference<Importer> reference, Entry service) {
            service.dispose();
        }

        public void modifiedService(ServiceReference<Importer> reference, Entry service) {
        }

        public Entry addingService(ServiceReference<Importer> reference) {
            return new Entry(FrameworkUtil.getBundle(ImportController.class).getBundleContext(), reference);
        }
    };

    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void setService(ChannelService service) {
        this.service = service;
    }

    public void start() {
        BundleContext context = FrameworkUtil.getBundle(ImportController.class).getBundleContext();
        this.tracker = new ServiceTracker(context, Importer.class, this.customizer);
        this.tracker.open();
        this.impManager = new ImportManager(context, this.jobManager);
    }

    public void stop() {
        this.tracker.close();
        this.impManager.dispose();
    }

    @RequestMapping(value={"/channel/{channelId}/import"})
    public ModelAndView index(@PathVariable(value="channelId") String channelId) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("channel", channel.getInformation());
            model.put("descriptions", this.getDescriptions());
            ImportDescriptor desc = new ImportDescriptor();
            desc.setChannelId(channel.getId().getId());
            desc.setType("channel");
            model.put("token", desc.toBase64());
            return new ModelAndView("index", model);
        });
    }

    @RequestMapping(value={"/import/perform"}, method={RequestMethod.POST, RequestMethod.GET})
    public ModelAndView perform(@RequestParameter(value="token") String token, @RequestParameter(value="request") ImportRequest request) {
        HashMap<String, JobHandle> model = new HashMap<String, JobHandle>();
        ImportDescriptor desc = ImportDescriptor.fromBase64((String)token);
        JobHandle job = this.impManager.perform(desc, request);
        model.put("job", job);
        return new ModelAndView("perform", model);
    }

    @RequestMapping(value={"/import/job/{id}/result"})
    public ModelAndView viewResult(@PathVariable(value="id") String jobId) {
        JobHandle job = this.jobManager.getJob(jobId);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("job", job);
        ImporterResult result = (ImporterResult)new GsonBuilder().create().fromJson(job.getResult(), ImporterResult.class);
        model.put("result", result);
        if (result != null) {
            return Channels.withChannel((ChannelService)this.service, (String)result.getChannelId(), ReadableChannel.class, channel -> {
                model.put("channel", channel.getInformation());
                return new ModelAndView("result", model);
            });
        }
        return new ModelAndView("result", model);
    }

    public ImporterDescription[] getDescriptions() {
        ImporterDescription[] result = (ImporterDescription[])this.tracker.getTracked().values().stream().map(Entry::getDescription).toArray(ImporterDescription[]::new);
        Arrays.sort(result, NAME_COMPARATOR);
        return result;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (!(object instanceof ChannelInformation)) {
            return null;
        }
        if (!request.isUserInRole("MANAGER")) {
            return null;
        }
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        ChannelInformation channel = (ChannelInformation)object;
        HashMap<String, String> model = new HashMap<String, String>(1);
        model.put("channelId", channel.getId());
        result.add(new MenuEntry("Import", 600, LinkTarget.createFromController(ImportController.class, (String)"index").expand(model), Modifier.DEFAULT, "import"));
        return result;
    }

    private static class Entry {
        private final BundleContext context;
        private final Importer service;
        private final ServiceReference<Importer> reference;
        private final ImporterDescription description;

        public Entry(BundleContext context, ServiceReference<Importer> reference) {
            this.context = context;
            this.reference = reference;
            this.service = (Importer)context.getService(reference);
            this.description = this.service.getDescription();
        }

        public void dispose() {
            this.context.ungetService(this.reference);
        }

        public ImporterDescription getDescription() {
            return this.description;
        }
    }

    public static class ImporterDescriptionLabelComparator
    implements Comparator<ImporterDescription> {
        @Override
        public int compare(ImporterDescription o1, ImporterDescription o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    }
}

