/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common;

import java.util.function.Supplier;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.ModelAndViewRequestHandler;
import org.eclipse.scada.utils.ExceptionHelper;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
public class CommonController {
    public static final String SUCCESS_VIEW = "common/success";
    public static final String SUCCESS_VIEW_TITLE = "title";
    public static final String SUCCESS_VIEW_SUBTITLE = "subtitle";
    public static final String SUCCESS_VIEW_MESSAGE = "message";
    public static final String ACCESS_DENIED_VIEW = "common/accessDenied";
    public static final String ERROR_VIEW = "common/error";
    public static final String ERROR_VIEW_TITLE = "title";
    public static final String ERROR_VIEW_SUBTITLE = "subtitle";
    public static final String ERROR_VIEW_RESULT = "result";
    public static final String ERROR_VIEW_MESSAGE = "message";
    public static final String ERROR_VIEW_STACKTRACE = "stacktrace";
    public static final String ERROR_VIEW_EXCEPTION = "exception";
    public static final String NOT_FOUND_VIEW = "common/notFound";
    public static final String NOT_FOUND_VIEW_TYPE = "type";
    public static final String NOT_FOUND_VIEW_ID = "id";

    public static ModelAndView createNotFound(String type, String id) {
        ModelAndView result = new ModelAndView(NOT_FOUND_VIEW);
        result.put(NOT_FOUND_VIEW_ID, (Object)id);
        result.put(NOT_FOUND_VIEW_TYPE, (Object)type);
        result.setAlternateViewResolver(CommonController.class);
        return result;
    }

    public static ModelAndView createError(String title, String result, Throwable e, Boolean showStackTrace) {
        return CommonController.createError(title, null, result, e, showStackTrace);
    }

    public static ModelAndView createError(String title, String subtitle, String result, Throwable e, Boolean showStackTrace) {
        ModelAndView mav = new ModelAndView(ERROR_VIEW);
        if (showStackTrace != null) {
            mav.put("showStackTrace", (Object)showStackTrace);
        } else {
            mav.put("showStackTrace", (Object)Boolean.getBoolean("drone.showStackTrace"));
        }
        mav.put("title", (Object)title);
        mav.put("subtitle", (Object)subtitle);
        mav.put(ERROR_VIEW_RESULT, (Object)result);
        mav.put(ERROR_VIEW_EXCEPTION, (Object)e);
        if (e != null) {
            mav.put("message", (Object)ExceptionHelper.getMessage((Throwable)e));
            mav.put(ERROR_VIEW_STACKTRACE, (Object)ExceptionHelper.formatted((Throwable)e));
        }
        mav.setAlternateViewResolver(CommonController.class);
        return mav;
    }

    public static ModelAndView createError(String title, String result, Throwable e) {
        return CommonController.createError(title, result, e, null);
    }

    public static ModelAndView createAccessDenied() {
        ModelAndView mav = new ModelAndView(ACCESS_DENIED_VIEW);
        mav.setAlternateViewResolver(CommonController.class);
        return mav;
    }

    public static ModelAndView createSuccess(String title, String subtitle, String message) {
        ModelAndView mav = new ModelAndView(SUCCESS_VIEW);
        mav.put("title", (Object)title);
        mav.put("subtitle", (Object)subtitle);
        mav.put("message", (Object)message);
        mav.setAlternateViewResolver(CommonController.class);
        return mav;
    }

    public static ModelAndViewRequestHandler wrap(Supplier<ModelAndView> supplier) {
        return new ModelAndViewRequestHandler(supplier.get(), CommonController.class, null);
    }
}

