/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import java.io.InputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.CacheEntry;
import org.eclipse.packagedrone.repo.channel.CacheEntryInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ChannelState;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;
import org.eclipse.packagedrone.repo.channel.provider.AccessContext;
import org.eclipse.packagedrone.repo.channel.provider.Channel;
import org.eclipse.packagedrone.repo.channel.provider.ModifyContext;
import org.eclipse.packagedrone.utils.Exceptions;
import org.eclipse.packagedrone.utils.io.IOConsumer;

final class ErrorChannel
implements Channel {
    private final String errorMessage;

    public ErrorChannel(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public <T> T modifyCall(ChannelService.ChannelOperation<T, ModifyContext> operation) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public <T> T accessCall(ChannelService.ChannelOperation<T, AccessContext> operation) {
        return (T)Exceptions.wrapException(() -> operation.process((Object)new AccessContext(){

            public boolean streamCacheEntry(MetaKey key, IOConsumer<CacheEntry> consumer) {
                return false;
            }

            public boolean stream(String artifactId, IOConsumer<InputStream> consumer) {
                return false;
            }

            public ChannelState getState() {
                ChannelState.Builder builder = new ChannelState.Builder();
                Instant now = Instant.now();
                builder.setCreationTimestamp(now);
                builder.setLocked(true);
                builder.setModificationTimestamp(now);
                CopyOnWriteArrayList<ValidationMessage> msgs = new CopyOnWriteArrayList<ValidationMessage>();
                msgs.add(new ValidationMessage("system", Severity.ERROR, ErrorChannel.this.errorMessage, Collections.emptySet()));
                builder.setValidationMessages(msgs);
                return builder.build();
            }

            public Map<MetaKey, String> getProvidedMetaData() {
                return Collections.emptyMap();
            }

            public SortedMap<MetaKey, String> getMetaData() {
                return Collections.emptySortedMap();
            }

            public Map<MetaKey, String> getExtractedMetaData() {
                return Collections.emptyMap();
            }

            public Map<MetaKey, CacheEntryInformation> getCacheEntries() {
                return Collections.emptyMap();
            }

            public Map<String, ArtifactInformation> getArtifacts() {
                return Collections.emptyMap();
            }
        }));
    }
}

