/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.upgrade;

import com.google.common.collect.HashMultimap;
import com.google.common.net.UrlEscapers;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.ChannelAspectInformation;
import org.eclipse.packagedrone.repo.Version;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectFactory;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectProcessor;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.manage.todo.BasicTask;
import org.eclipse.packagedrone.repo.manage.todo.DefaultTaskProvider;
import org.eclipse.packagedrone.repo.manage.todo.Task;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.common.Button;
import org.eclipse.packagedrone.web.common.Modifier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTaskProvider
extends DefaultTaskProvider
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTaskProvider.class);
    private static final Button PERFORM_BUTTON = new Button("Refresh aspect", "refresh", Modifier.DEFAULT);
    private static final Button PERFORM_ALL_BUTTON = new Button("Refresh channel", "refresh", Modifier.DEFAULT);
    private static final Button PERFORM_ALL_SUPER_BUTTON = new Button("Refresh all channels", "refresh", Modifier.DEFAULT);
    private final ServiceListener listener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            UpgradeTaskProvider.this.handleServiceChange(event);
        }
    };
    private ChannelService service;
    private BundleContext context;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public void start() throws Exception {
        logger.info("Starting channel aspect upgrade watcher");
        this.context = FrameworkUtil.getBundle(UpgradeTaskProvider.class).getBundleContext();
        this.context.addServiceListener(this.listener, String.format("(%s=%s)", "objectClass", ChannelAspectFactory.class.getName()));
        Thread t = new Thread(){

            @Override
            public void run() {
                UpgradeTaskProvider.this.refresh();
            }
        };
        t.setName("UpgradeTaskProvider/initialScan");
        t.setDaemon(true);
        t.start();
    }

    public void stop() {
        this.context.removeServiceListener(this.listener);
    }

    protected void handleServiceChange(ServiceEvent event) {
        logger.debug("service change - {} - {}", (Object)event.getType(), (Object)event.getServiceReference());
        switch (event.getType()) {
            case 1: 
            case 4: {
                this.refresh();
            }
        }
    }

    public void refresh() {
        logger.info("Refreshing");
        this.setTasks(this.updateState());
    }

    private List<Task> updateState() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Profile.Handle handle = Profile.start((Object)((Object)this), (String)"updateState");){
            Map infos = ChannelAspectProcessor.scanAspectInformations((BundleContext)this.context);
            LinkedList<Task> result = new LinkedList<Task>();
            HashMultimap missing = HashMultimap.create();
            HashMultimap channels = HashMultimap.create();
            for (ChannelInformation channelInformation : this.service.list()) {
                logger.debug("Checking channel: {}", (Object)channelInformation.getId());
                SortedMap states = channelInformation.getAspectStates();
                for (Map.Entry entry : states.entrySet()) {
                    logger.debug("\t{}", entry.getKey());
                    ChannelAspectInformation info = (ChannelAspectInformation)infos.get(entry.getKey());
                    if (info == null) {
                        missing.put((Object)((String)entry.getKey()), (Object)channelInformation);
                        continue;
                    }
                    logger.debug("\t{} - {} -> {}", new Object[]{info.getFactoryId(), entry.getValue(), info.getVersion()});
                    if (info.getVersion().equals((Object)Version.valueOf((String)((String)entry.getValue())))) continue;
                    result.add(this.makeUpgradeTask(channelInformation, info, (String)entry.getValue()));
                    channels.put((Object)channelInformation, (Object)((String)entry.getKey()));
                }
            }
            for (Map.Entry entry : channels.asMap().entrySet()) {
                ChannelInformation channel = (ChannelInformation)entry.getKey();
                LinkTarget target = new LinkTarget(String.format("/channel/%s/refreshAllAspects", UrlEscapers.urlPathSegmentEscaper().escape(channel.getId())));
                result.add((Task)new BasicTask("Refresh channel: " + channel.makeTitle(), 100, "Channel aspects active in this channel have been updated. You can refresh the whole channel.", target, RequestMethod.GET, PERFORM_ALL_BUTTON));
            }
            for (Map.Entry entry : missing.asMap().entrySet()) {
                String missingChannels = ((Collection)entry.getValue()).stream().map(ChannelId::getId).collect(Collectors.joining(", "));
                result.add((Task)new BasicTask(String.format("Fix missing channel aspect: %s", entry.getKey()), 1, String.format("The channel aspect '%s' is being used but not installed in the system. Channels: %s", entry.getKey(), missingChannels), null));
            }
            if (!channels.isEmpty()) {
                result.add((Task)new BasicTask("Refresh all channels", 1, "Refresh all channels in one big task", new LinkTarget(String.format("/job/%s/create", "drone.aspect.refreshAllChannels")), RequestMethod.POST, PERFORM_ALL_SUPER_BUTTON));
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Task makeUpgradeTask(ChannelInformation channel, ChannelAspectInformation info, String fromVersion) {
        String factoryId;
        String channelName = channel.makeTitle();
        try {
            factoryId = URLEncoder.encode(info.getFactoryId(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            factoryId = info.getFactoryId();
        }
        LinkTarget target = new LinkTarget(String.format("/channel/%s/refreshAspect?aspect=%s", channel.getId(), factoryId));
        String description = String.format("The aspect %s (%s) in channel %s was upgraded from version %s to %s. The channel aspect has to be re-processed.", info.getLabel(), info.getFactoryId(), channelName, fromVersion, info.getVersion());
        return new BasicTask("Upgrade aspect data", 1000, description, target, RequestMethod.POST, PERFORM_BUTTON);
    }

    public void handleEvent(Event event) {
        logger.debug("Received event - {}", (Object)event.getTopic());
        String topic = event.getTopic();
        Object op = event.getProperty("operation");
        if (topic.startsWith("drone/channel/") && ("remove".equals(op) || "refresh".equals(op))) {
            this.refresh();
        }
    }
}

