/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.web;

import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactoryInformation;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryInformation;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.TriggerDescriptor;
import org.eclipse.packagedrone.repo.trigger.TriggerHandle;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.repo.trigger.web.TriggerEntry;
import org.eclipse.packagedrone.repo.web.utils.ChannelServiceController;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.scada.utils.ExceptionHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Controller
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@RequestMapping(value={"/trigger"})
public class TriggerController
extends ChannelServiceController
implements InterfaceExtender {
    private ProcessorFactoryTracker processorFactoryTracker;
    private ConfiguredTriggerFactoryTracker configuredTriggerFactoryTracker;

    public void start() {
        BundleContext context = FrameworkUtil.getBundle(TriggerController.class).getBundleContext();
        this.processorFactoryTracker = new ProcessorFactoryTracker(context);
        this.configuredTriggerFactoryTracker = new ConfiguredTriggerFactoryTracker(context);
    }

    public void stop() {
        if (this.processorFactoryTracker != null) {
            this.processorFactoryTracker.close();
            this.processorFactoryTracker = null;
        }
        if (this.configuredTriggerFactoryTracker != null) {
            this.configuredTriggerFactoryTracker.close();
            this.configuredTriggerFactoryTracker = null;
        }
    }

    @RequestMapping(value={"/channel/{channelId}/list"})
    public ModelAndView list(@PathVariable(value="channelId") String channelId) {
        return this.withChannel(channelId, TriggeredChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            Breadcrumbs.Builder builder = new Breadcrumbs.Builder();
            builder.add("Home", "/");
            builder.add("Channel", "/channel/{0}/view", new String[]{channel.getId().getId()});
            builder.add("Triggers");
            builder.buildTo(model);
            model.put("channel", channel.getId());
            model.put("triggers", this.makeEntries(channel.listTriggers()));
            model.put("triggerFactories", this.makeTriggerFactories());
            model.put("triggerFactoryTracker", factoryId -> this.configuredTriggerFactoryTracker.getFactoryInformation(factoryId).orElse(null));
            model.put("processorFactoryTracker", factoryId -> this.processorFactoryTracker.getFactoryInformation(factoryId).orElse(null));
            return new ModelAndView("channel/list", model);
        });
    }

    private List<ConfiguredTriggerFactoryInformation> makeTriggerFactories() {
        return this.configuredTriggerFactoryTracker.getFactoryInformations();
    }

    @RequestMapping(value={"/channel/{channelId}/removeProcessor"}, method={RequestMethod.POST})
    public ModelAndView removeProcessor(@PathVariable(value="channelId") String channelId, @RequestParameter(value="triggerId") String triggerId, @RequestParameter(value="processorId") String processorId) {
        return this.withChannel(channelId, TriggeredChannel.class, channel -> {
            channel.deleteProcessor(triggerId, processorId);
            return ModelAndView.referer((String)String.format("/channel/%s", UrlEscapers.urlPathSegmentEscaper().escape(channelId)));
        });
    }

    @RequestMapping(value={"/channel/{channelId}/removeTrigger"}, method={RequestMethod.POST})
    public ModelAndView removeTrigger(@PathVariable(value="channelId") String channelId, @RequestParameter(value="triggerId") String triggerId) {
        return this.withChannel(channelId, TriggeredChannel.class, channel -> {
            channel.deleteConfiguredTrigger(triggerId);
            return ModelAndView.referer((String)String.format("/channel/%s", UrlEscapers.urlPathSegmentEscaper().escape(channelId)));
        });
    }

    @RequestMapping(value={"/channel/{channelId}/reorder"}, method={RequestMethod.POST})
    public void reorder(@PathVariable(value="channelId") String channelId, @RequestParameter(value="triggerId1") String triggerId1, @RequestParameter(value="processorId1") String processorId1, @RequestParameter(value="triggerId2") String triggerId2, @RequestParameter(value="processorId2", required=false) String processorId2, HttpServletResponse response) throws IOException {
        this.withChannelRun(channelId, TriggeredChannel.class, channel -> this.handleFullReorder((TriggeredChannel)channel, response, triggerId1, processorId1, triggerId2, processorId2));
    }

    private void handleFullReorder(TriggeredChannel channel, HttpServletResponse response, String triggerId1, String processorId1, String triggerId2, String processorId2) throws IOException {
        response.setContentType("text/plain");
        try {
            channel.reorder(triggerId1, processorId1, triggerId2, processorId2);
            response.setStatus(200);
            response.getWriter().append("OK");
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            response.sendError(400, ExceptionHelper.getMessage((Throwable)e));
        }
    }

    private List<TriggerEntry> makeEntries(Collection<TriggerHandle> triggers) {
        return triggers.stream().map(this::makeEntry).collect(Collectors.toList());
    }

    private TriggerEntry makeEntry(TriggerHandle trigger) {
        List processors;
        Optional desc = trigger.getDescriptor();
        if (desc.isPresent()) {
            processors = this.processorFactoryTracker.getFactoriesFor(((TriggerDescriptor)desc.get()).getSupportedContexts());
            Collections.sort(processors, Comparator.comparing(ProcessorFactoryInformation::getLabel));
        } else {
            processors = Collections.emptyList();
        }
        return new TriggerEntry(trigger, processors);
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (!(object instanceof ChannelId)) {
            return null;
        }
        if (!request.isUserInRole("MANAGER")) {
            return null;
        }
        ChannelId channelId = (ChannelId)object;
        HashMap<String, String> model = new HashMap<String, String>(1);
        model.put("channelId", channelId.getId());
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        result.add(new MenuEntry("Triggers", 3300, LinkTarget.createFromController(TriggerController.class, (String)"list").expand(model), Modifier.DEFAULT, "cog"));
        return result;
    }
}

