/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.npm;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.adapter.npm.ModuleHandler;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.manage.system.SystemService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class NpmServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ServiceTracker<ChannelService, ChannelService> tracker;
    private ServiceTracker<SystemService, SystemService> sysTracker;

    public void init() throws ServletException {
        super.init();
        BundleContext context = FrameworkUtil.getBundle(NpmServlet.class).getBundleContext();
        this.tracker = new ServiceTracker(context, ChannelService.class, null);
        this.tracker.open();
        this.sysTracker = new ServiceTracker(context, SystemService.class, null);
        this.sysTracker.open();
    }

    public void destroy() {
        this.tracker.close();
        this.sysTracker.close();
        super.destroy();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path == null) {
            path = "/";
        }
        if ("/".equals(path)) {
            response.getWriter().write("NPM adapter");
            return;
        }
        ChannelService service = (ChannelService)this.tracker.getService();
        SystemService sysService = (SystemService)this.sysTracker.getService();
        if (service == null || sysService == null) {
            response.getWriter().write("System not operational");
            response.setStatus(503);
            return;
        }
        String[] toks = (path = path.replaceAll("^/+", "")).split("/");
        if (toks.length < 1) {
            this.notFound(request, response);
            return;
        }
        try {
            service.accessRun(ChannelService.By.nameOrId((String)toks[0]), ReadableChannel.class, channel -> this.processGet(request, response, sysService, (ReadableChannel)channel, toks));
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            response.getWriter().format("Channel '%s' not found", toks[0]);
            response.setStatus(404);
        }
    }

    private void processGet(HttpServletRequest request, HttpServletResponse response, SystemService service, ReadableChannel channel, String[] toks) throws IOException {
        if (toks.length == 2) {
            new ModuleHandler(service, channel, toks[1], true).process(response);
            return;
        }
        response.getWriter().write("No handler");
        response.setStatus(404);
    }

    private void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getWriter().format("Resource '%s' not found", request.getPathInfo());
        response.setStatus(404);
    }
}

