/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.trigger.TriggerHandle;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.repo.web.utils.ChannelServiceController;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;

public abstract class AbstractCommonTriggerConfigurationController<T>
extends ChannelServiceController {
    protected abstract ModelAndView handleEditUpdate(TriggeredChannel var1, TriggerHandle var2, T var3, BindingResult var4);

    protected abstract ModelAndView handleCreateUpdate(TriggeredChannel var1, T var2, BindingResult var3);

    protected abstract ModelAndView handleEdit(TriggeredChannel var1, TriggerHandle var2);

    protected abstract ModelAndView handleCreate(TriggeredChannel var1);

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView configure(@RequestParameter(value="channelId") String channelId, @RequestParameter(value="triggerId", required=false) String triggerId) {
        return this.withChannel(channelId, TriggeredChannel.class, channel -> {
            if (triggerId == null || triggerId.isEmpty()) {
                return this.handleCreate((TriggeredChannel)channel);
            }
            Optional triggerHandle = channel.getTrigger(triggerId);
            if (!triggerHandle.isPresent()) {
                return CommonController.createNotFound((String)"trigger", (String)triggerId);
            }
            TriggerHandle handle = (TriggerHandle)triggerHandle.get();
            if (!handle.getConfiguration().isPresent()) {
                return this.notConfigurable((TriggeredChannel)channel, triggerId);
            }
            return this.handleEdit((TriggeredChannel)channel, handle);
        });
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView update(@RequestParameter(value="channelId") String channelId, @RequestParameter(value="triggerId", required=false) String triggerId, @Valid @FormData(value="command") T command, BindingResult result) {
        return this.withChannel(channelId, TriggeredChannel.class, channel -> {
            if (triggerId == null || triggerId.isEmpty()) {
                return this.handleCreateUpdate((TriggeredChannel)channel, command, result);
            }
            Optional triggerHandle = channel.getTrigger(triggerId);
            if (!triggerHandle.isPresent()) {
                return CommonController.createNotFound((String)"trigger", (String)triggerId);
            }
            TriggerHandle handle = (TriggerHandle)triggerHandle.get();
            if (!handle.getConfiguration().isPresent()) {
                return this.notConfigurable((TriggeredChannel)channel, triggerId);
            }
            return this.handleEditUpdate((TriggeredChannel)channel, handle, command, result);
        });
    }

    private ModelAndView notConfigurable(TriggeredChannel channel, String triggerId) {
        return CommonController.createError((String)"Error", (String)"Error", (String)String.format("Trigger '%s' is not configurable", triggerId));
    }

    protected Map<String, Object> makeModel(TriggeredChannel channel, TriggerHandle trigger, Supplier<T> configuration) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("command", configuration.get());
        result.put("channelId", channel.getId().getId());
        if (trigger != null) {
            result.put("triggerId", trigger.getId());
        }
        this.fillModel(result);
        return result;
    }

    protected void fillModel(Map<String, Object> model) {
    }
}

