/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common;

import com.google.common.net.UrlEscapers;
import org.eclipse.packagedrone.repo.trigger.TriggerHandle;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessor;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.repo.trigger.common.AbstractCommonProcessorConfigurationController;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;

public abstract class SimpleProcessorConfigurationController<T>
extends AbstractCommonProcessorConfigurationController<T> {
    private final String processorFactoryId;
    private final String viewName;

    protected abstract T newModel();

    protected abstract T parseModel(String var1);

    protected abstract String writeModel(T var1);

    public SimpleProcessorConfigurationController(String processorFactoryId, String viewName) {
        this.processorFactoryId = processorFactoryId;
        this.viewName = viewName;
    }

    @Override
    protected ModelAndView handleCreate(TriggeredChannel channel, TriggerHandle trigger) {
        return new ModelAndView(this.viewName, this.makeModel(channel, trigger, null, false, this::newModel));
    }

    @Override
    protected ModelAndView handleEdit(TriggeredChannel channel, TriggerHandle trigger, TriggerProcessor processor) {
        return new ModelAndView(this.viewName, this.makeModel(channel, trigger, processor, true, () -> this.parseModel(processor.getConfiguration().getConfiguration())));
    }

    @Override
    protected ModelAndView handleCreateUpdate(TriggeredChannel channel, TriggerHandle triggerHandle, T command, BindingResult result) {
        if (result.hasErrors()) {
            return new ModelAndView(this.viewName, this.makeModel(channel, triggerHandle, null, false, () -> command));
        }
        channel.addProcessor(triggerHandle.getId(), this.processorFactoryId, this.writeModel(command));
        return new ModelAndView(String.format("redirect:/trigger/channel/%s/list", UrlEscapers.urlPathSegmentEscaper().escape(channel.getId().getId())));
    }

    @Override
    protected ModelAndView handleEditUpdate(TriggeredChannel channel, TriggerHandle triggerHandle, TriggerProcessor triggerProcessor, T command, BindingResult result) {
        if (result.hasErrors()) {
            return new ModelAndView(this.viewName, this.makeModel(channel, triggerHandle, triggerProcessor, true, () -> command));
        }
        channel.modifyProcessor(triggerHandle.getId(), triggerProcessor.getId(), this.writeModel(command));
        return new ModelAndView(String.format("redirect:/trigger/channel/%s/list", UrlEscapers.urlPathSegmentEscaper().escape(channel.getId().getId())));
    }
}

