/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.todo.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.manage.todo.Task;
import org.eclipse.packagedrone.repo.manage.todo.TaskListener;
import org.eclipse.packagedrone.repo.manage.todo.TaskProvider;
import org.eclipse.packagedrone.repo.manage.todo.ToDoService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ToDoServiceImpl
implements ToDoService {
    private final BundleContext context;
    private final ServiceTracker<TaskProvider, TaskProvider> tracker;
    private final ServiceTrackerCustomizer<TaskProvider, TaskProvider> customizer = new ServiceTrackerCustomizer<TaskProvider, TaskProvider>(){

        public void removedService(ServiceReference<TaskProvider> reference, TaskProvider service) {
            ToDoServiceImpl.this.removeService(service);
            ToDoServiceImpl.this.context.ungetService(reference);
        }

        public void modifiedService(ServiceReference<TaskProvider> reference, TaskProvider service) {
            ToDoServiceImpl.this.removeService(service);
            ToDoServiceImpl.this.addService(service);
        }

        public TaskProvider addingService(ServiceReference<TaskProvider> reference) {
            TaskProvider service = (TaskProvider)ToDoServiceImpl.this.context.getService(reference);
            ToDoServiceImpl.this.addService(service);
            return service;
        }
    };
    private final Set<TaskProvider> providers = new CopyOnWriteArraySet<TaskProvider>();
    private final TaskListener taskListener = new TaskListener(){

        @Override
        public void tasksChanged(Collection<? extends Task> tasks) {
            ToDoServiceImpl.this.updateCache();
        }
    };
    private volatile List<Task> allTasks;
    private volatile List<Task> openTasks;

    public ToDoServiceImpl() {
        this.context = FrameworkUtil.getBundle(ToDoService.class).getBundleContext();
        this.tracker = new ServiceTracker(this.context, TaskProvider.class, this.customizer);
    }

    protected void addService(TaskProvider service) {
        this.providers.add(service);
        service.addListener(this.taskListener);
        this.updateCache();
    }

    protected void removeService(TaskProvider service) {
        service.removeListener(this.taskListener);
        this.providers.remove(service);
        this.updateCache();
    }

    protected void updateCache() {
        this.allTasks = this.buildCache();
        this.openTasks = this.filterOpen(this.allTasks);
    }

    private List<Task> filterOpen(List<Task> tasks) {
        return Collections.unmodifiableList(tasks.stream().filter(Task::isOpen).collect(Collectors.toList()));
    }

    protected List<Task> buildCache() {
        ArrayList<? extends Task> result = new ArrayList<Task>();
        for (TaskProvider provider : this.providers) {
            result.addAll(provider.getTasks());
        }
        Collections.sort(result, Task.PRIORITY_COMPARATOR);
        return Collections.unmodifiableList(result);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    @Override
    public List<Task> getOpenTasks() {
        return this.openTasks;
    }
}

