/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.scada.utils.inject.Optional;
import org.eclipse.scada.utils.str.StringHelper;

public class InjectHelper {
    public static void injectFields(Object target, Collection<Field> fields, Map<String, Object> context, List<Object> specialInstances) {
        block4: for (Field field : fields) {
            boolean optional;
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            Named named = field.getAnnotation(Named.class);
            String name = named != null ? named.value() : field.getName();
            boolean bl = optional = field.getAnnotation(Optional.class) != null;
            if (named == null) {
                for (Object o : specialInstances) {
                    if (!field.getType().isAssignableFrom(o.getClass())) continue;
                    try {
                        InjectHelper.setField(target, field, o);
                        continue block4;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (!context.containsKey(name)) {
                if (optional) continue;
                throw new IllegalStateException(String.format("Unable to find '%s' in current context - Context: %s", name, context));
            }
            Object value = context.get(name);
            if (!field.getType().isAssignableFrom(value.getClass())) {
                throw new IllegalStateException(String.format("Field '%s' cannot be assigned - sourceType %s is incompatible with fieldType %s", field.getName(), value.getClass(), field.getType()));
            }
            try {
                InjectHelper.setField(target, field, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setField(Object target, Field field, Object value) throws IllegalArgumentException, IllegalAccessException {
        try {
            Method setter = target.getClass().getMethod("set" + StringHelper.toUpperFirst(field.getName()), field.getType());
            setter.invoke(target, value);
        }
        catch (Exception exception) {}
        if (field.isAccessible()) {
            field.set(target, value);
        } else {
            field.setAccessible(true);
            try {
                field.set(target, value);
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    public static Object getField(Object target, Field field) throws IllegalArgumentException, IllegalAccessException {
        if (field.isAccessible()) {
            return field.get(target);
        }
        field.setAccessible(true);
        try {
            Object object = field.get(target);
            return object;
        }
        finally {
            field.setAccessible(false);
        }
    }
}

