/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class HexDumpOutputStream
extends OutputStream {
    private final PrintStream ps;
    private final int width = 16;
    private int counter = 0;

    public HexDumpOutputStream(PrintStream ps) {
        this.ps = ps;
    }

    public HexDumpOutputStream(OutputStream os) {
        this(new PrintStream(os));
    }

    public void wrap() {
        if (this.counter > 0) {
            this.ps.println();
        }
        this.ps.println();
        this.counter = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.counter > 0) {
            this.ps.print(' ');
        }
        this.ps.print(String.format("%02X", (byte)(0xFF & b)));
        ++this.counter;
        if (this.counter > 16) {
            this.counter = 0;
            this.wrap();
        }
    }

    @Override
    public void close() {
        this.ps.close();
    }
}

