/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.lang;

public class BitArray {
    private byte[] data;

    public BitArray() {
        this.data = new byte[0];
    }

    public BitArray(int initialSize) {
        this.data = new byte[initialSize / 8 + 1];
    }

    public BitArray(byte[] data) {
        this.data = data;
    }

    public boolean get(int bit) {
        if (bit < 0) {
            return false;
        }
        int pos = bit >> 8;
        if (pos >= this.data.length) {
            return false;
        }
        return (this.data[pos] & 1 << bit % 8) > 0;
    }

    public void set(int bit, boolean value) {
        if (bit < 0) {
            return;
        }
        int pos = bit / 8;
        this.ensureSize(pos + 1);
        if (value) {
            int n = pos;
            this.data[n] = (byte)(this.data[n] | 1 << bit % 8);
        } else {
            int n = pos;
            this.data[n] = (byte)(this.data[n] & ~(1 << bit % 8));
        }
    }

    private void ensureSize(int size) {
        if (this.data.length < size) {
            byte[] newData = new byte[size];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
    }

    public byte[] toArray() {
        return this.data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x|", b));
            ++n2;
        }
        sb.append("]");
        return sb.toString();
    }
}

