/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.deploy;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.eclipse.packagedrone.repo.channel.deploy.DeployKey;

public class DeployGroup {
    public static final Comparator<DeployGroup> NAME_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(DeployGroup::getName));
    private final String id;
    private final String name;
    private final List<DeployKey> keys;

    public DeployGroup(String id, String name, List<DeployKey> keys) {
        this.id = id;
        this.name = name;
        this.keys = keys != null ? new CopyOnWriteArrayList<DeployKey>(keys) : Collections.emptyList();
    }

    public DeployGroup(String id, String name, List<DeployKey> keys, Function<DeployGroup, Collection<DeployKey>> keyGenerator) {
        this.id = id;
        this.name = name;
        this.keys = keys != null ? new CopyOnWriteArrayList<DeployKey>(keys) : new CopyOnWriteArrayList();
        Collection<DeployKey> result = keyGenerator.apply(this);
        if (result != null) {
            this.keys.addAll(result);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<DeployKey> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployGroup)) {
            return false;
        }
        DeployGroup other = (DeployGroup)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

