/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.deps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.deps.Dependency;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.eclipse.packagedrone.utils.rpm.header.Header;

public final class Dependencies {
    private Dependencies() {
    }

    public static void putRequirements(Header<RpmTag> header, Collection<Dependency> requirements) {
        Dependencies.putDependencies(header, requirements, RpmTag.REQUIRE_NAME, RpmTag.REQUIRE_VERSION, RpmTag.REQUIRE_FLAGS);
    }

    public static void putProvides(Header<RpmTag> header, Collection<Dependency> provides) {
        Dependencies.putDependencies(header, provides, RpmTag.PROVIDE_NAME, RpmTag.PROVIDE_VERSION, RpmTag.PROVIDE_FLAGS);
    }

    public static void putConflicts(Header<RpmTag> header, Collection<Dependency> conflicts) {
        Dependencies.putDependencies(header, conflicts, RpmTag.CONFLICT_NAME, RpmTag.CONFLICT_VERSION, RpmTag.CONFLICT_FLAGS);
    }

    public static void putObsoletes(Header<RpmTag> header, Collection<Dependency> obsoletes) {
        Dependencies.putDependencies(header, obsoletes, RpmTag.OBSOLETE_NAME, RpmTag.OBSOLETE_VERSION, RpmTag.OBSOLETE_FLAGS);
    }

    private static void putDependencies(Header<RpmTag> header2, Collection<Dependency> dependencies, RpmTag namesTag, RpmTag versionsTag, RpmTag flagsTag) {
        if (dependencies.isEmpty()) {
            return;
        }
        ArrayList<Dependency> deps = new ArrayList<Dependency>(dependencies);
        Collections.sort(deps, Comparator.comparing(Dependency::getName).thenComparing(Comparator.comparing(Dependency::getVersion, Comparator.nullsFirst(Comparator.naturalOrder()))));
        Header.putFields(header2, deps, namesTag, String[]::new, Dependency::getName, (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
        Header.putFields(header2, deps, versionsTag, String[]::new, Dependency::getVersion, (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
        Header.putIntFields(header2, deps, flagsTag, dep -> RpmDependencyFlags.encode(dep.getFlags()));
    }
}

