/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.header;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.header.HeaderEntry;
import org.eclipse.packagedrone.utils.rpm.header.Type;

public class Header<T extends RpmBaseTag> {
    private final Map<Integer, Object> entries = new LinkedHashMap<Integer, Object>();

    public Header(HeaderEntry[] entries) {
        if (entries != null) {
            HeaderEntry[] headerEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                HeaderEntry entry = headerEntryArray[n2];
                this.entries.put(entry.getTag(), entry);
                ++n2;
            }
        }
    }

    public Header(Header<T> other) {
        Objects.requireNonNull(other);
        this.entries.putAll(other.entries);
    }

    public Header() {
    }

    public int size() {
        return this.entries.size();
    }

    public void putNull(int tag) {
        this.entries.put(tag, null);
    }

    public void putNull(T tag) {
        this.entries.put(tag.getValue(), null);
    }

    public void putByte(int tag, byte ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, value);
    }

    public void putByte(T tag, byte ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), value);
    }

    public void putShort(int tag, short ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, value);
    }

    public void putShort(T tag, short ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), value);
    }

    public void putInt(int tag, int ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, value);
    }

    public void putInt(T tag, int ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), value);
    }

    public void putLong(int tag, long ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, value);
    }

    public void putLong(T tag, long ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), value);
    }

    public void putString(int tag, String value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, value);
    }

    public void putString(T tag, String value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), value);
    }

    public void putStringOptional(int tag, String value) {
        if (value == null) {
            return;
        }
        this.entries.put(tag, value);
    }

    public void putStringOptional(T tag, String value) {
        if (value == null) {
            return;
        }
        this.entries.put(tag.getValue(), value);
    }

    public void putStringArray(int tag, String ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, value);
    }

    public void putStringArray(T tag, String ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), value);
    }

    public void putI18nString(int tag, String ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, Arrays.stream(value).map(v -> new I18nString((String)v)).toArray(I18nString[]::new));
    }

    public void putI18nString(T tag, String ... value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), Arrays.stream(value).map(v -> new I18nString((String)v)).toArray(I18nString[]::new));
    }

    public void putBlob(int tag, byte[] value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, ByteBuffer.wrap(value));
    }

    public void putBlob(int tag, ByteBuffer value) {
        Objects.requireNonNull(value);
        this.entries.put(tag, value);
    }

    public void putBlob(T tag, byte[] value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), ByteBuffer.wrap(value));
    }

    public void putBlob(T tag, ByteBuffer value) {
        Objects.requireNonNull(value);
        this.entries.put(tag.getValue(), value);
    }

    public void putSize(long value, T intTag, T longTag) {
        Objects.requireNonNull(intTag);
        Objects.requireNonNull(longTag);
        if (value <= 0L) {
            value = 0L;
        }
        if (value > Integer.MAX_VALUE) {
            this.putLong(longTag, value);
        } else {
            this.putInt(intTag, (int)value);
        }
    }

    public void remove(int tag) {
        this.entries.remove(tag);
    }

    public void remove(RpmTag tag) {
        this.entries.remove(tag.getValue());
    }

    public Object get(int tag) {
        return this.entries.get(tag);
    }

    public Object get(RpmTag tag) {
        return this.entries.get(tag.getValue());
    }

    public HeaderEntry[] makeEntries() {
        return (HeaderEntry[])this.entries.entrySet().stream().map(Header::makeEntry).toArray(HeaderEntry[]::new);
    }

    private static HeaderEntry makeEntry(Map.Entry<Integer, Object> entry) {
        Object val = entry.getValue();
        int tag = entry.getKey();
        if (val instanceof HeaderEntry) {
            return (HeaderEntry)val;
        }
        if (val == null) {
            return new HeaderEntry(Type.NULL, tag, 0, null);
        }
        if (val instanceof byte[]) {
            byte[] value = (byte[])val;
            return new HeaderEntry(Type.BYTE, tag, value.length, value);
        }
        if (val instanceof short[]) {
            short[] value = (short[])val;
            byte[] data = new byte[value.length * 2];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            short[] sArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                short v = sArray[n2];
                buffer.putShort(v);
                ++n2;
            }
            return new HeaderEntry(Type.SHORT, tag, value.length, data);
        }
        if (val instanceof int[]) {
            int[] value = (int[])val;
            byte[] data = new byte[value.length * 4];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            int[] nArray = value;
            int n = value.length;
            int n3 = 0;
            while (n3 < n) {
                int v = nArray[n3];
                buffer.putInt(v);
                ++n3;
            }
            return new HeaderEntry(Type.INT, tag, value.length, data);
        }
        if (val instanceof long[]) {
            long[] value = (long[])val;
            byte[] data = new byte[value.length * 8];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            long[] lArray = value;
            int n = value.length;
            int n4 = 0;
            while (n4 < n) {
                long v = lArray[n4];
                buffer.putLong(v);
                ++n4;
            }
            return new HeaderEntry(Type.LONG, tag, value.length, data);
        }
        if (val instanceof String) {
            String value = (String)val;
            return new HeaderEntry(Type.STRING, tag, 1, Header.makeStringData(new ByteArrayOutputStream(), value).toByteArray());
        }
        if (val instanceof ByteBuffer) {
            byte[] data;
            ByteBuffer value = (ByteBuffer)val;
            if (value.hasArray()) {
                data = value.array();
            } else {
                data = new byte[value.remaining()];
                value.get(data);
            }
            return new HeaderEntry(Type.BLOB, tag, data.length, data);
        }
        if (val instanceof String[]) {
            String[] value = (String[])val;
            return new HeaderEntry(Type.STRING_ARRAY, tag, value.length, Header.makeStringsData(new ByteArrayOutputStream(), value).toByteArray());
        }
        if (val instanceof I18nString[]) {
            I18nString[] value = (I18nString[])val;
            return new HeaderEntry(Type.I18N_STRING, tag, value.length, Header.makeStringsData(new ByteArrayOutputStream(), value).toByteArray());
        }
        throw new IllegalArgumentException(String.format("Unable to process value type: %s", val.getClass()));
    }

    private static <T extends OutputStream> T makeStringData(T out, String string) {
        try {
            if (string != null) {
                out.write(string.getBytes(StandardCharsets.UTF_8));
            }
            out.write(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out;
    }

    private static <T extends OutputStream> T makeStringsData(T out, String[] strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Header.makeStringData(out, s);
            ++n2;
        }
        return out;
    }

    private static <T extends OutputStream> T makeStringsData(T out, I18nString[] strings) {
        I18nString[] i18nStringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            I18nString s = i18nStringArray[n2];
            if (s != null) {
                Header.makeStringData(out, s.value);
            } else {
                Header.makeStringData(out, null);
            }
            ++n2;
        }
        return out;
    }

    public static <E, V, T extends RpmBaseTag> void putFields(Header<T> header, Collection<E> entries, T tag, ArrayAllocator<V> arrayAllocator, Function<E, V> func, Putter<T, V> putter) {
        if (entries.isEmpty()) {
            return;
        }
        V[] values = arrayAllocator.allocate(entries.size());
        int i = 0;
        for (E entry : entries) {
            values[i] = func.apply(entry);
            ++i;
        }
        putter.put(header, tag, values);
    }

    public static <E, T extends RpmBaseTag> void putShortFields(Header<T> header, Collection<E> entries, T tag, ToShortFunction<E> func) {
        if (entries.isEmpty()) {
            return;
        }
        short[] values = new short[entries.size()];
        int i = 0;
        for (E entry : entries) {
            values[i] = func.applyAsShort(entry);
            ++i;
        }
        header.putShort(tag, values);
    }

    public static <E, T extends RpmBaseTag> void putIntFields(Header<T> header, Collection<E> entries, T tag, ToIntFunction<E> func) {
        if (entries.isEmpty()) {
            return;
        }
        int[] values = new int[entries.size()];
        int i = 0;
        for (E entry : entries) {
            values[i] = func.applyAsInt(entry);
            ++i;
        }
        header.putInt(tag, values);
    }

    public static <E, T extends RpmBaseTag> void putLongFields(Header<T> header, Collection<E> entries, T tag, ToLongFunction<E> func) {
        if (entries.isEmpty()) {
            return;
        }
        long[] values = new long[entries.size()];
        int i = 0;
        for (E entry : entries) {
            values[i] = func.applyAsLong(entry);
            ++i;
        }
        header.putLong(tag, values);
    }

    @FunctionalInterface
    public static interface ArrayAllocator<T> {
        public T[] allocate(int var1);
    }

    private static final class I18nString {
        private final String value;

        public I18nString(String value) {
            this.value = value;
        }
    }

    @FunctionalInterface
    public static interface Putter<T extends RpmBaseTag, V> {
        public void put(Header<T> var1, T var2, V[] var3);
    }

    @FunctionalInterface
    public static interface ToShortFunction<T> {
        public short applyAsShort(T var1);
    }
}

