/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.DispatcherServlet;
import org.eclipse.packagedrone.web.ErrorHandler;
import org.eclipse.packagedrone.web.dispatcher.Dispatcher;
import org.eclipse.packagedrone.web.dispatcher.DispatcherHttpContext;
import org.eclipse.packagedrone.web.dispatcher.internal.ErrorHandlerTracker;
import org.eclipse.packagedrone.web.dispatcher.internal.FilterTracker;
import org.eclipse.packagedrone.web.dispatcher.internal.internal.jsp.JspBundle;
import org.eclipse.packagedrone.web.dispatcher.internal.internal.jsp.JspBundleCustomizer;
import org.eclipse.packagedrone.web.util.Servlets;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class DispatcherServletInitializer {
    private WebContainer webContainer;
    private BundleTracker<JspBundle> jspTracker;
    private FilterTracker proxyFilter;
    private DispatcherHttpContext context;
    private ErrorHandlerTracker errorHandler;
    private static final String PROP_PREFIX = "osgi.web.dispatcher";
    private static final String PROP_PREFIX_MP = "osgi.web.dispatcher.multipart";

    public void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void start() throws ServletException, NamespaceException {
        BundleContext bundleContext = FrameworkUtil.getBundle(DispatcherServletInitializer.class).getBundleContext();
        this.context = Dispatcher.createContext(bundleContext);
        this.errorHandler = new ErrorHandlerTracker();
        Hashtable<String, String> initparams = new Hashtable<String, String>();
        MultipartConfigElement multipart = Servlets.createMultiPartConfiguration((String)PROP_PREFIX_MP);
        DispatcherServlet servlet = new DispatcherServlet();
        servlet.setErrorHandler((ErrorHandler)this.errorHandler);
        this.webContainer.registerServlet((Servlet)servlet, "dispatcher", new String[]{"/"}, initparams, Integer.valueOf(1), Boolean.valueOf(false), multipart, (HttpContext)this.context);
        this.proxyFilter = new FilterTracker(bundleContext);
        this.webContainer.registerFilter((Filter)this.proxyFilter, new String[]{"/*"}, null, null, (HttpContext)this.context);
        initparams = new Hashtable();
        ((Dictionary)initparams).put("filter-mapping-dispatcher", "request");
        this.webContainer.registerFilter((Filter)new BundleFilter(), new String[]{"/bundle/*"}, null, initparams, (HttpContext)this.context);
        this.jspTracker = new BundleTracker(bundleContext, 34, (BundleTrackerCustomizer)new JspBundleCustomizer((HttpService)this.webContainer, this.context));
        this.jspTracker.open();
    }

    public void stop() {
        this.context.dispose();
        this.jspTracker.close();
        this.webContainer.unregister("/");
        this.errorHandler.dispose();
    }

    public static class BundleFilter
    implements Filter {
        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (response instanceof HttpServletResponse) {
                ((HttpServletResponse)response).setStatus(404);
                response.setContentType("text/plain");
                response.getWriter().write("Resource not found");
            }
        }

        public void init(FilterConfig arg0) throws ServletException {
        }
    }
}

