/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.manage.system.ConfigurationBackupService;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.service.LoginException;
import org.eclipse.packagedrone.sec.service.SecurityService;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.util.BasicAuthentication;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@ViewResolver(value="/WEB-INF/views/backup/%s.jsp")
@RequestMapping(value={"/system/backup"})
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class BackupController
implements InterfaceExtender {
    private static final Logger logger = LoggerFactory.getLogger(BackupController.class);
    private ConfigurationBackupService service;
    private SecurityService securityService;

    public void setService(ConfigurationBackupService service) {
        this.service = service;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @RequestMapping
    public ModelAndView main() {
        HashMap model = new HashMap(1);
        return new ModelAndView("index", model);
    }

    @RequestMapping(value={"/export"})
    public void exportData(HttpServletResponse response) throws IOException {
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", String.format("attachment; filename=package-drone-backup-%1$tY%1$tm%1$td-%1$tH-%1$tM.zip", new Date()));
        response.setStatus(200);
        this.service.createConfigurationBackup((OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/provision"}, method={RequestMethod.POST})
    @Secured(value=false)
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public void provision(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.internalProvision(request, response);
    }

    protected void internalProvision(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] authToks = BasicAuthentication.parseAuthorization((HttpServletRequest)request);
        if (authToks == null) {
            BasicAuthentication.request((HttpServletResponse)response, (String)"provision", (String)"Please authenticate");
            return;
        }
        try {
            UserInformation user = this.securityService.login(authToks[0], authToks[1]);
            if (user == null) {
                this.quickResponse(response, 403, "Not allowed");
                return;
            }
        }
        catch (LoginException loginException) {
            this.quickResponse(response, 403, "Not allowed");
            return;
        }
        try {
            this.service.provisionConfiguration((InputStream)request.getInputStream());
            this.waitForService();
            this.quickResponse(response, 200, "OK");
        }
        catch (Exception e) {
            logger.warn("Failed to import configuration", (Throwable)e);
            this.quickResponse(response, 500, "Failed to import configuration");
            return;
        }
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public ModelAndView restoreData(@RequestParameter(value="file") Part part) {
        try {
            this.service.restoreConfiguration(part.getInputStream());
            this.waitForService();
            return new ModelAndView("redirect:/system/backup");
        }
        catch (Exception e) {
            return CommonController.createError((String)"Restore", (String)"Failed to restore configuration", (Throwable)e, (Boolean)true);
        }
    }

    private void waitForService() {
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker(FrameworkUtil.getBundle(BackupController.class).getBundleContext(), ChannelService.class, null);){
            try {
                tracker.waitForService(5000L);
            }
            catch (InterruptedException interruptedException) {
                tracker.close();
            }
        }
    }

    protected void quickResponse(HttpServletResponse response, int statusCode, String message) throws IOException {
        response.setStatus(statusCode);
        response.setContentType("text/plain");
        response.getWriter().write(message);
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        if (request.isUserInRole("ADMIN")) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            result.add(new MenuEntry("System", 20000, "Configuration", 200, LinkTarget.createFromController(BackupController.class, (String)"main"), null, null));
            return result;
        }
        return null;
    }
}

