/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.binding.MessageBindingError;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;
import org.eclipse.packagedrone.web.controller.validator.ValidationResult;

public class SimpleValidationContext
implements ValidationContext {
    private final Map<String, List<BindingError>> result = new HashMap<String, List<BindingError>>();
    private final Set<String> markers = new HashSet<String>();

    public Set<String> getMarkers() {
        return this.markers;
    }

    @Override
    public void error(String path, BindingError error) {
        List<BindingError> pos;
        if (path == null) {
            path = "";
        }
        if ((pos = this.result.get(path)) == null) {
            pos = new LinkedList<BindingError>();
            this.result.put(path, pos);
        }
        pos.add(error);
    }

    @Override
    public void error(BindingError error) {
        this.error(null, error);
    }

    @Override
    public void error(String errorMessage) {
        this.error(null, errorMessage);
    }

    @Override
    public void error(String path, String errorMessage) {
        this.error(path, new MessageBindingError(errorMessage));
    }

    public ValidationResult getResult() {
        ValidationResult vr = new ValidationResult();
        vr.setErrors(this.result);
        vr.setMarkers(this.markers);
        return vr;
    }

    @Override
    public void setMarker(String marker) {
        this.markers.add(marker);
    }
}

