/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.job;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.packagedrone.job.ErrorInformation;

public class ImporterResult {
    private String channelId;
    private List<Entry> entries = new LinkedList<Entry>();
    private long totalBytes;

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public static class Entry {
        private final String id;
        private final String name;
        private final long size;
        private final ErrorInformation error;
        private final List<Entry> children = new LinkedList<Entry>();

        public Entry(String id, String name, long size) {
            this.id = id;
            this.name = name;
            this.size = size;
            this.error = null;
        }

        public Entry(String name, ErrorInformation error) {
            this.id = null;
            this.name = name;
            this.size = -1L;
            this.error = error;
        }

        public Entry(String name) {
            this.id = null;
            this.name = name;
            this.size = -1L;
            this.error = null;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public ErrorInformation getError() {
            return this.error;
        }

        public boolean isSuccess() {
            return this.error == null && this.id != null;
        }

        public boolean isSkipped() {
            return this.id == null && this.error == null;
        }

        public boolean isError() {
            return this.error != null;
        }

        public List<Entry> getChildren() {
            return this.children;
        }
    }
}

