/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.internal.local;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.bouncycastle.openpgp.PGPException;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.repo.signing.pgp.internal.local.PgpSigningService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry {
    private static final Logger logger = LoggerFactory.getLogger(Entry.class);
    private final BundleContext context;
    private final String pid;
    private ServiceRegistration<SigningService> handle;

    public Entry(String pid, BundleContext context) {
        this.pid = pid;
        this.context = context;
    }

    public void dispose() {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
    }

    public void update(Dictionary<String, ?> properties) {
        PgpSigningService service;
        this.dispose();
        String keyring = (String)properties.get("keyring");
        String keyId = (String)properties.get("key.id");
        String passphrase = (String)properties.get("key.passphrase");
        Object description = properties.get("description");
        try {
            service = PgpSigningService.create(new File(keyring), keyId, passphrase);
        }
        catch (IOException | PGPException e) {
            logger.warn("Failed to register signing service", e);
            return;
        }
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put("service.pid", this.pid);
        ((Dictionary)serviceProperties).put("service.description", (String)description);
        this.handle = this.context.registerService(SigningService.class, (Object)service, serviceProperties);
    }
}

