/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.scheduler.simple.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.packagedrone.utils.scheduler.ScheduledTask;
import org.eclipse.packagedrone.utils.scheduler.simple.Scheduler;
import org.eclipse.packagedrone.utils.scheduler.simple.internal.SchedulerThreadFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScheduler
implements Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(SimpleScheduler.class);
    private ScheduledExecutorService executor;
    private final ServiceTrackerCustomizer<ScheduledTask, Entry> scheduledCustomizer = new ServiceTrackerCustomizer<ScheduledTask, Entry>(){

        public void removedService(ServiceReference<ScheduledTask> reference, Entry service) {
            service.dispose();
        }

        public void modifiedService(ServiceReference<ScheduledTask> reference, Entry service) {
            service.reschedule(SimpleScheduler.getPeriod(reference));
        }

        public Entry addingService(ServiceReference<ScheduledTask> reference) {
            BundleContext context = FrameworkUtil.getBundle(SimpleScheduler.class).getBundleContext();
            Entry entry = new Entry((ScheduledTask)context.getService(reference));
            entry.reschedule(SimpleScheduler.getPeriod(reference));
            return entry;
        }
    };
    private final ServiceTracker<ScheduledTask, Entry> tracker;

    protected static Long getPeriod(ServiceReference<?> ref) {
        Object periodMsVal = ref.getProperty("scheduler.period.ms");
        if (periodMsVal instanceof Number) {
            return ((Number)periodMsVal).longValue();
        }
        if (periodMsVal instanceof String) {
            try {
                return Long.parseLong((String)periodMsVal);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public SimpleScheduler() {
        BundleContext context = FrameworkUtil.getBundle(SimpleScheduler.class).getBundleContext();
        this.tracker = new ServiceTracker(context, ScheduledTask.class, this.scheduledCustomizer);
    }

    public void start() {
        logger.info("Starting ... ");
        this.executor = Executors.newSingleThreadScheduledExecutor(new SchedulerThreadFactory());
        this.tracker.open();
    }

    public void stop() {
        logger.info("Stopping ... ");
        this.tracker.close();
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private class Entry
    implements Runnable {
        private final ScheduledTask service;
        private ScheduledFuture<?> job;

        public Entry(ScheduledTask service) {
            this.service = service;
            logger.debug("Created job: {}", (Object)service);
        }

        public void reschedule(Long period) {
            logger.debug("Reschedule job: {} ms - {}", (Object)period, (Object)this.service);
            if (period != null && period > 0L) {
                if (this.job != null) {
                    logger.debug("Cancel old job");
                    this.job.cancel(false);
                }
                this.job = SimpleScheduler.this.executor.scheduleAtFixedRate(this, 0L, period, TimeUnit.MILLISECONDS);
                logger.debug("Started new job");
            } else if (this.job != null) {
                logger.debug("Cancel job");
                this.job.cancel(false);
                this.job = null;
            }
        }

        public void dispose() {
            this.reschedule(null);
        }

        @Override
        public void run() {
            logger.debug("Running job {} ... ", (Object)this.service);
            try {
                this.service.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.debug("Running job {} ... done!", (Object)this.service);
        }
    }
}

