/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.profiler;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.packagedrone.utils.profiler.DumpProfileDataHandler;
import org.eclipse.packagedrone.utils.profiler.ProfileDataHandler;
import org.eclipse.packagedrone.utils.profiler.XmlProfileDataHandler;
import org.eclipse.packagedrone.utils.profiler.internal.ProfilerInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Profile {
    private static final Logger logger = LoggerFactory.getLogger(Profile.class);
    private static Handle NOP = new Handle(){

        @Override
        public void close() {
        }

        @Override
        public Handle createChild(String operation) {
            return NOP;
        }

        @Override
        public void task(String operation) {
        }
    };
    private static ThreadLocal<Handle> activeProfilers = new ThreadLocal();
    private static ProfileDataHandler HANDLER;

    static {
        String value = System.getProperty("drone.profile");
        if (value != null) {
            String[] toks;
            if ("true".equalsIgnoreCase(value)) {
                HANDLER = DumpProfileDataHandler.INSTANCE;
            } else if (value.startsWith("xml:") && (toks = value.split(":", 2)).length == 2) {
                try {
                    HANDLER = new XmlProfileDataHandler(new File(toks[1]).toPath());
                }
                catch (Throwable e) {
                    logger.error("Failed to initialize XML profile data handler", e);
                }
            }
            if (HANDLER == null) {
                Profile.debug("Failed to initialize profile data handler. Activated as: '%s'", value);
            }
        }
    }

    private Profile() {
    }

    private static boolean isActive() {
        return HANDLER != null;
    }

    public static Handle start(Object service, String methodName) {
        return Profile.start(Profile.makeOperation(service, methodName));
    }

    public static Handle start(String operation) {
        if (!Profile.isActive()) {
            return NOP;
        }
        Handle handle = activeProfilers.get();
        if (handle == null) {
            Profile.debug("create : %s", operation);
            return new HandleImpl(operation);
        }
        Profile.debug("child : %s : %s", handle, operation);
        return handle.createChild(operation);
    }

    private static String makeOperation(Object service, String methodName) {
        return String.format("%s.%s", service.getClass().getName(), methodName);
    }

    public static <T> T call(Object service, String methodName, Callable<T> call) {
        return Profile.call(Profile.makeOperation(service, methodName), call);
    }

    public static <T> T call(String operation, Callable<T> call) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Handle handle = Profile.start(operation);){
                return call.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void run(Object service, String methodName, Runnable run) {
        Profile.run(Profile.makeOperation(service, methodName), run);
    }

    public static void run(String operation, Runnable run) {
        Profile.call(operation, () -> {
            run.run();
            return null;
        });
    }

    public static <T> T proxy(T service, Class<T> iface) {
        if (service == null) {
            return null;
        }
        if (Profile.isActive()) {
            return iface.cast(Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ProfilerInvocationHandler(service)));
        }
        return service;
    }

    private static void debug(String format, Object ... args) {
        if (Boolean.getBoolean("drone.profile.debug")) {
            System.out.print(Thread.currentThread().getName());
            System.out.print(": ");
            System.out.format(format, args);
            System.out.println();
        }
    }

    private static ProfileDataHandler getHandler() {
        return HANDLER;
    }

    public static class DurationEntry {
        private final String operation;
        private final Duration duration;
        private List<DurationEntry> entries;

        public DurationEntry(String operation, Duration duration) {
            this.operation = operation;
            this.duration = duration;
        }

        public DurationEntry(String operation, Duration duration, List<DurationEntry> entries) {
            this.operation = operation;
            this.duration = duration;
            this.entries = entries;
        }

        public String getOperation() {
            return this.operation;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public List<DurationEntry> getEntries() {
            return this.entries;
        }
    }

    public static interface Handle
    extends AutoCloseable {
        @Override
        public void close();

        public Handle createChild(String var1);

        public void task(String var1);
    }

    public static class HandleImpl
    implements Handle {
        private final HandleImpl parent;
        private final Instant start;
        private final String operation;
        private final LinkedList<DurationEntry> entries = new LinkedList();
        private Instant taskStart;
        private String taskName;

        public HandleImpl(String operation) {
            this(operation, null);
        }

        public HandleImpl(String operation, HandleImpl parent) {
            this.parent = parent;
            this.operation = operation;
            activeProfilers.set(this);
            this.start = Instant.now();
        }

        @Override
        public Handle createChild(String operation) {
            return new HandleImpl(operation, this);
        }

        public String toString() {
            return "[" + this.operation + "]";
        }

        @Override
        public void task(String taskName) {
            Profile.debug("task : %s", new Object[]{taskName});
            Instant now = Instant.now();
            this.closeTask(now);
            this.taskStart = now;
            this.taskName = taskName;
        }

        private void closeTask(Instant now) {
            if (this.taskStart != null) {
                Duration duration = Duration.between(this.taskStart, now);
                DurationEntry entry = new DurationEntry(this.taskName, duration, Collections.emptyList());
                this.entries.add(entry);
            }
        }

        @Override
        public void close() {
            Instant now = Instant.now();
            this.closeTask(now);
            Duration duration = Duration.between(this.start, now);
            DurationEntry entry = new DurationEntry(this.operation, duration, this.entries);
            activeProfilers.set(this.parent);
            if (this.parent != null) {
                Profile.debug("close : %s : %s", new Object[]{this.parent, this.operation});
                this.parent.entries.add(entry);
            } else {
                Profile.debug("dump : %s", new Object[]{this.operation});
                ProfileDataHandler handler = Profile.getHandler();
                if (handler != null) {
                    handler.handle(entry);
                }
            }
        }
    }
}

