/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ArtifactRule {
    private static final List<ArtifactRule> REPOSITORY_RULES;
    private static final List<ArtifactRule> ZIP_RULES;
    private final Filter filter;
    private final String pattern;

    static {
        ArrayList<ArtifactRule> list = new ArrayList<ArtifactRule>(3);
        try {
            list.add(new ArtifactRule(FrameworkUtil.createFilter((String)"(& (classifier=osgi.bundle))"), "${repoUrl}/plugins/${id}/${version}/${id}_${version}.jar"));
            list.add(new ArtifactRule(FrameworkUtil.createFilter((String)"(& (classifier=binary))"), "${repoUrl}/binary/${id}/${version}/${id}_${version}"));
            list.add(new ArtifactRule(FrameworkUtil.createFilter((String)"(& (classifier=org.eclipse.update.feature))"), "${repoUrl}/features/${id}/${version}/${id}_${version}.jar"));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        REPOSITORY_RULES = Collections.unmodifiableList(list);
        list = new ArrayList(3);
        try {
            list.add(new ArtifactRule(FrameworkUtil.createFilter((String)"(& (classifier=osgi.bundle))"), "${repoUrl}/plugins/${id}_${version}.jar"));
            list.add(new ArtifactRule(FrameworkUtil.createFilter((String)"(& (classifier=binary))"), "${repoUrl}/binary/${id}_${version}"));
            list.add(new ArtifactRule(FrameworkUtil.createFilter((String)"(& (classifier=org.eclipse.update.feature))"), "${repoUrl}/features/${id}_${version}.jar"));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        ZIP_RULES = Collections.unmodifiableList(list);
    }

    public ArtifactRule(Filter filter, String pattern) {
        this.filter = filter;
        this.pattern = pattern;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getPattern() {
        return this.pattern;
    }

    public static List<ArtifactRule> getDefaultZipRules() {
        return ZIP_RULES;
    }

    public static List<ArtifactRule> getDefaultRepositoryRules() {
        return REPOSITORY_RULES;
    }
}

