/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.build;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.eclipse.packagedrone.utils.rpm.build.PayloadProvider;

public class PayloadRecorder
implements AutoCloseable,
PayloadProvider {
    private final boolean autoFinish;
    private final Path tempFile;
    private final CountingOutputStream payloadCounter;
    private final CountingOutputStream archiveCounter;
    private final CpioArchiveOutputStream archiveStream;
    private OutputStream fileStream;
    private boolean finished;
    private boolean closed;

    public PayloadRecorder() throws IOException {
        this(true);
    }

    public PayloadRecorder(boolean autoFinish) throws IOException {
        this.autoFinish = autoFinish;
        this.tempFile = Files.createTempFile("rpm-", null, new FileAttribute[0]);
        try {
            this.fileStream = new BufferedOutputStream(Files.newOutputStream(this.tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
            this.payloadCounter = new CountingOutputStream(this.fileStream);
            GZIPOutputStream payloadStream = new GZIPOutputStream((OutputStream)this.payloadCounter);
            this.archiveCounter = new CountingOutputStream((OutputStream)payloadStream);
            this.archiveStream = new CpioArchiveOutputStream((OutputStream)this.archiveCounter, 1, 4, "UTF-8");
        }
        catch (IOException e) {
            Files.deleteIfExists(this.tempFile);
            throw e;
        }
    }

    public Result addFile(String targetPath, Path path) throws IOException {
        return this.addFile(targetPath, path, null);
    }

    public Result addFile(String targetPath, Path path, Consumer<CpioArchiveEntry> customizer) throws IOException {
        MessageDigest digest;
        long size = Files.size(path);
        CpioArchiveEntry entry = new CpioArchiveEntry(targetPath);
        entry.setSize(size);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.archiveStream.putArchiveEntry((ArchiveEntry)entry);
        try {
            digest = this.createDigest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ByteStreams.copy((InputStream)new DigestInputStream(in, digest), (OutputStream)this.archiveStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.archiveStream.closeArchiveEntry();
        return new Result(size, digest.digest());
    }

    public Result addFile(String targetPath, ByteBuffer data) throws IOException {
        return this.addFile(targetPath, data, null);
    }

    public Result addFile(String targetPath, ByteBuffer data, Consumer<CpioArchiveEntry> customizer) throws IOException {
        MessageDigest digest;
        long size = data.remaining();
        CpioArchiveEntry entry = new CpioArchiveEntry(targetPath);
        entry.setSize(size);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.archiveStream.putArchiveEntry((ArchiveEntry)entry);
        try {
            digest = this.createDigest();
            digest.update(data.slice());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        WritableByteChannel channel = Channels.newChannel((OutputStream)this.archiveStream);
        while (data.hasRemaining()) {
            channel.write(data);
        }
        this.archiveStream.closeArchiveEntry();
        return new Result(size, digest.digest());
    }

    private MessageDigest createDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("MD5");
    }

    public Result addFile(String targetPath, InputStream stream) throws IOException {
        return this.addFile(targetPath, stream, null);
    }

    public Result addFile(String targetPath, InputStream stream, Consumer<CpioArchiveEntry> customizer) throws IOException {
        Path tmpFile = Files.createTempFile("rpm-payload-", null, new FileAttribute[0]);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                ByteStreams.copy((InputStream)stream, (OutputStream)os);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Result result = this.addFile(targetPath, tmpFile, customizer);
            return result;
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    public Result addDirectory(String targetPath, Consumer<CpioArchiveEntry> customizer) throws IOException {
        CpioArchiveEntry entry = new CpioArchiveEntry(targetPath);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.archiveStream.putArchiveEntry((ArchiveEntry)entry);
        this.archiveStream.closeArchiveEntry();
        return new Result(4096L, null);
    }

    public Result addSymbolicLink(String targetPath, String linkTo, Consumer<CpioArchiveEntry> customizer) throws IOException {
        byte[] bytes = linkTo.getBytes(StandardCharsets.UTF_8);
        CpioArchiveEntry entry = new CpioArchiveEntry(targetPath);
        entry.setSize((long)bytes.length);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.archiveStream.putArchiveEntry((ArchiveEntry)entry);
        this.archiveStream.write(bytes);
        this.archiveStream.closeArchiveEntry();
        return new Result(bytes.length, null);
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.archiveStream.close();
    }

    @Override
    public long getArchiveSize() throws IOException {
        this.checkFinished(true);
        return this.archiveCounter.getCount();
    }

    @Override
    public long getPayloadSize() throws IOException {
        this.checkFinished(true);
        return this.payloadCounter.getCount();
    }

    @Override
    public FileChannel openChannel() throws IOException {
        this.checkFinished(true);
        return FileChannel.open(this.tempFile, StandardOpenOption.READ);
    }

    private void checkFinished(boolean allowAutoFinish) throws IOException {
        if (!this.finished && this.autoFinish && allowAutoFinish) {
            this.finish();
        }
        if (!this.finished) {
            throw new IllegalStateException("Recoderd has to be finished before accessing payload information or data");
        }
        if (this.closed) {
            throw new IllegalStateException("Recorder is already closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        try {
            if (this.fileStream != null) {
                this.fileStream.close();
            }
        }
        finally {
            Files.deleteIfExists(this.tempFile);
        }
    }

    public static class Result {
        private final long size;
        private final byte[] sha1;

        private Result(long size, byte[] sha1) {
            this.size = size;
            this.sha1 = sha1;
        }

        public long getSize() {
            return this.size;
        }

        public byte[] getSha1() {
            return this.sha1;
        }
    }
}

