/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.packagedrone.utils.converter.JSON;

@JSON
public class MavenCoordinates
implements Comparable<MavenCoordinates> {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String extension;

    public MavenCoordinates() {
    }

    public MavenCoordinates(MavenCoordinates other) {
        this.groupId = other.groupId;
        this.artifactId = other.artifactId;
        this.version = other.version;
        this.classifier = other.classifier;
        this.extension = other.extension;
    }

    public MavenCoordinates(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public MavenCoordinates toBase() {
        if (this.classifier == null && this.extension == null) {
            return this;
        }
        return new MavenCoordinates(this.groupId, this.artifactId, this.version);
    }

    public static MavenCoordinates fromString(String coords) {
        return MavenCoordinates.fromArtifact((Artifact)new DefaultArtifact(coords));
    }

    public static MavenCoordinates fromResult(ArtifactResult result) {
        if (result == null) {
            return null;
        }
        return MavenCoordinates.fromArtifact(result.getRequest().getArtifact());
    }

    public static MavenCoordinates fromArtifact(Artifact art) {
        if (art == null) {
            return null;
        }
        MavenCoordinates coords = new MavenCoordinates();
        coords.setGroupId(art.getGroupId());
        coords.setArtifactId(art.getArtifactId());
        coords.setVersion(art.getVersion());
        coords.setClassifier(art.getClassifier());
        coords.setExtension(art.getExtension());
        return coords;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId);
        sb.append(':').append(this.artifactId);
        if (this.extension != null && !this.extension.isEmpty()) {
            sb.append(':').append(this.extension);
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            sb.append(':').append(this.classifier);
        }
        sb.append(':').append(this.version);
        return sb.toString();
    }

    @Override
    public int compareTo(MavenCoordinates o) {
        int rc = this.compare(this.groupId, o.groupId);
        if (rc != 0) {
            return rc;
        }
        rc = this.compare(this.artifactId, o.artifactId);
        if (rc != 0) {
            return rc;
        }
        rc = this.compare(this.version, o.version);
        if (rc != 0) {
            return rc;
        }
        rc = this.compare(this.classifier, o.classifier);
        if (rc != 0) {
            return rc;
        }
        return this.compare(this.extension, o.extension);
    }

    private int compare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenCoordinates other = (MavenCoordinates)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

