/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.job.apm.model;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.job.State;
import org.eclipse.packagedrone.job.apm.model.JobInstanceEntity;

public class JobWriteModel {
    private static final Duration JOB_FORGET_DURATION = Duration.ofHours(8L);
    private final Map<String, JobInstanceEntity> jobs;
    private final Map<String, JobInstanceEntity> cloneMap = new HashMap<String, JobInstanceEntity>();

    public JobWriteModel() {
        this.jobs = new HashMap<String, JobInstanceEntity>();
    }

    public JobWriteModel(Map<String, JobInstanceEntity> jobs) {
        this.jobs = jobs;
    }

    public JobInstanceEntity getJobForUpdate(String id) {
        JobInstanceEntity job = this.cloneMap.get(id);
        if (job != null) {
            return job;
        }
        job = this.jobs.get(id);
        if (job == null) {
            return null;
        }
        JobInstanceEntity clonedJob = new JobInstanceEntity(job);
        this.cloneMap.put(id, clonedJob);
        return clonedJob;
    }

    public Map<String, JobInstanceEntity> makeJobMap() {
        HashMap<String, JobInstanceEntity> result = new HashMap<String, JobInstanceEntity>(this.jobs);
        Instant timedOut = Instant.now().minus(JOB_FORGET_DURATION);
        JobWriteModel.cloneActiveJobs(this.jobs.values(), result, timedOut);
        JobWriteModel.cloneActiveJobs(this.cloneMap.values(), result, timedOut);
        return result;
    }

    protected static void cloneActiveJobs(Collection<JobInstanceEntity> jobs, Map<String, JobInstanceEntity> result, Instant timedOut) {
        jobs.stream().filter(job -> job.getState() != State.COMPLETE || job.getCreation().isAfter(timedOut)).forEach(job -> {
            JobInstanceEntity jobInstanceEntity = result.put(job.getId(), (JobInstanceEntity)job);
        });
    }

    public void addJob(JobInstanceEntity ji) {
        if ((ji = new JobInstanceEntity(ji)).getId() == null) {
            throw new NullPointerException("Job ID must not be null");
        }
        this.cloneMap.put(ji.getId(), ji);
    }
}

