/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.utils.converter.ConversionContext;
import org.eclipse.packagedrone.utils.converter.ConversionException;
import org.eclipse.packagedrone.utils.converter.ConvertBy;
import org.eclipse.packagedrone.utils.converter.Converter;
import org.eclipse.packagedrone.utils.converter.DefaultProvider;
import org.eclipse.packagedrone.utils.converter.impl.BooleanToStringConverter;
import org.eclipse.packagedrone.utils.converter.impl.IntegerToStringConverter;
import org.eclipse.packagedrone.utils.converter.impl.JsonToStringConverter;
import org.eclipse.packagedrone.utils.converter.impl.LongToStringConverter;
import org.eclipse.packagedrone.utils.converter.impl.PrimitiveBooleanDefault;
import org.eclipse.packagedrone.utils.converter.impl.StringToArrayConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToBooleanConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToEnumConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToIntegerConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToJsonConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToLongConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToPrimitiveBooleanConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToPrimitiveIntegerConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToPrimitiveLongConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringToSetConverter;
import org.eclipse.packagedrone.utils.converter.impl.StringifyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterManager {
    private static final Logger logger = LoggerFactory.getLogger(ConversionResult.class);
    private final Collection<Converter> converters = new LinkedList<Converter>();
    private final Collection<DefaultProvider> defaults = new LinkedList<DefaultProvider>();

    public static ConverterManager create() {
        ConverterManager result = new ConverterManager();
        result.addConverter(StringToIntegerConverter.INSTANCE);
        result.addConverter(StringToBooleanConverter.INSTANCE);
        result.addConverter(StringToPrimitiveBooleanConverter.INSTANCE);
        result.addConverter(StringToPrimitiveIntegerConverter.INSTANCE);
        result.addConverter(StringToPrimitiveLongConverter.INSTANCE);
        result.addConverter(BooleanToStringConverter.INSTANCE);
        result.addConverter(IntegerToStringConverter.INSTANCE);
        result.addConverter(StringToSetConverter.INSTANCE);
        result.addConverter(StringToJsonConverter.INSTANCE);
        result.addConverter(JsonToStringConverter.INSTANCE);
        result.addConverter(LongToStringConverter.INSTANCE);
        result.addConverter(StringToLongConverter.INSTANCE);
        result.addConverter(StringToEnumConverter.INSTANCE);
        result.addConverter(StringToArrayConverter.INSTANCE);
        result.addConverter(StringifyConverter.INSTANCE);
        result.addDefault(PrimitiveBooleanDefault.INSTANCE);
        return result;
    }

    public void addConverter(Converter converter) {
        this.converters.add(converter);
    }

    public void addDefault(DefaultProvider defaultProvider) {
        this.defaults.add(defaultProvider);
    }

    public <T> T convertTo(Object value, Class<T> clazz) throws ConversionException {
        return this.convertToByClass(value, clazz, null);
    }

    public <T> T convertTo(Object value, Class<T> clazz, AnnotatedElement targetElement) throws ConversionException {
        return this.convertToByClass(value, clazz, targetElement, () -> {
            ConvertBy[] ann = (ConvertBy[])targetElement.getAnnotationsByType(ConvertBy.class);
            if (ann != null && ann.length > 0) {
                return Arrays.asList(ann).stream().map(ConvertBy::value).collect(Collectors.toList());
            }
            return null;
        });
    }

    public <T> T convertToBy(Object value, Class<T> clazz, Supplier<Collection<ConvertBy>> converterProvider) throws ConversionException {
        return this.convertToByClass(value, clazz, () -> {
            Collection provider = (Collection)converterProvider.get();
            if (provider == null || provider.isEmpty()) {
                return null;
            }
            return provider.stream().map(ConvertBy::value).collect(Collectors.toList());
        });
    }

    public <T> T convertToByClass(Object value, Class<T> clazz, Supplier<Collection<Class<? extends Converter>>> converterProvider) throws ConversionException {
        return this.convertToByClass(value, clazz, null, converterProvider);
    }

    public <T> T convertToByClass(Object value, Class<T> clazz, final AnnotatedElement annotatedElement, Supplier<Collection<Class<? extends Converter>>> converterProvider) throws ConversionException {
        ConversionResult<T> result;
        if (value == null) {
            return this.getDefault(clazz);
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        Class<?> from = value.getClass();
        final Collection<Class<? extends Converter>> cvtClasses = converterProvider != null ? converterProvider.get() : null;
        ConversionContext context = new ConversionContext(){

            public <R> R convert(Object value, Class<R> clazz) throws ConversionException {
                return ConverterManager.this.convertToByClass(value, clazz, annotatedElement, () -> cvtClasses);
            }
        };
        if (cvtClasses != null && (result = this.tryConvertByClass(value, from, clazz, annotatedElement, cvtClasses, context)) != null) {
            return result.value;
        }
        Collection<Class<? extends Converter>> annotatedConverters = this.findAnnotatedConverters(clazz);
        if (annotatedConverters != null && (result = this.tryConvertByClass(value, from, clazz, annotatedElement, annotatedConverters, context)) != null) {
            return result.value;
        }
        result = this.tryConvert(value, from, clazz, annotatedElement, this.converters, context);
        if (result != null) {
            return result.value;
        }
        throw new ConversionException(String.format("Unable to convert %s to %s", value.getClass(), clazz.getName()));
    }

    private <T> ConversionResult<T> tryConvertByClass(Object value, Class<?> from, Class<T> to, AnnotatedElement annotatedElement, Collection<Class<? extends Converter>> converters, ConversionContext context) {
        for (Class<? extends Converter> cvtClass : converters) {
            Converter cvt;
            try {
                cvt = cvtClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.warn("Failed to instantiate converter", (Throwable)e);
                continue;
            }
            ConversionResult<T> result = this.tryConvert(value, from, to, annotatedElement, cvt, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> ConversionResult<T> tryConvert(Object value, Class<?> from, Class<T> to, AnnotatedElement annotatedElement, Collection<Converter> converters, ConversionContext context) {
        for (Converter cvt : converters) {
            ConversionResult<T> result = this.tryConvert(value, from, to, annotatedElement, cvt, context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <T> ConversionResult<T> tryConvert(Object value, Class<?> from, Class<T> to, AnnotatedElement annotatedElement, Converter cvt, ConversionContext context) {
        if (!cvt.canConvert(from, to, annotatedElement)) {
            return null;
        }
        Object o = cvt.convertTo(value, to, context);
        if (o == null) {
            return new ConversionResult<Object>(null);
        }
        if (to.isAssignableFrom(o.getClass())) {
            return new ConversionResult<T>(to.cast(o));
        }
        if (to.isPrimitive()) {
            return new ConversionResult<Object>(o);
        }
        throw new ConversionException(String.format("Invalid result type (expected: %s, actual: %s)", to.getName(), o.getClass().getName()));
    }

    private Collection<Class<? extends Converter>> findAnnotatedConverters(Class<?> to) {
        ConvertBy[] ann = (ConvertBy[])to.getAnnotationsByType(ConvertBy.class);
        if (ann == null || ann.length <= 0) {
            return null;
        }
        ArrayList<Class<? extends Converter>> result = new ArrayList<Class<? extends Converter>>(ann.length);
        ConvertBy[] convertByArray = ann;
        int n = ann.length;
        int n2 = 0;
        while (n2 < n) {
            ConvertBy cb = convertByArray[n2];
            result.add(cb.value());
            ++n2;
        }
        return result;
    }

    public <T> T getDefault(Class<T> clazz) {
        for (DefaultProvider provider : this.defaults) {
            if (!provider.providesFor(clazz)) continue;
            return (T)provider.defaultValue();
        }
        return null;
    }

    private static final class ConversionResult<T> {
        T value;

        public ConversionResult(T value) {
            this.value = value;
        }
    }
}

