/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.packagedrone.utils.converter.ConversionContext;
import org.eclipse.packagedrone.utils.converter.ConversionException;
import org.eclipse.packagedrone.utils.converter.Converter;

public class StringToArrayConverter
implements Converter {
    public static final StringToArrayConverter INSTANCE = new StringToArrayConverter();

    @Override
    public boolean canConvert(Class<?> from, Class<?> to) {
        if (!to.isArray()) {
            return false;
        }
        Class<?> compClass = to.getComponentType();
        return compClass != null;
    }

    @Override
    public Object convertTo(Object value, Class<?> clazz, ConversionContext context) {
        if (value == null) {
            return null;
        }
        Class<?> compClass = clazz.getComponentType();
        List<String> input = value instanceof String[] ? Arrays.asList((String[])value) : Collections.singletonList((String)value);
        return this.convertToComponent(input, compClass, context);
    }

    private Object convertToComponent(List<String> input, Class<?> compClass, ConversionContext context) throws ConversionException {
        Object result = Array.newInstance(compClass, input.size());
        int i = 0;
        for (String tok : input) {
            try {
                Array.set(result, i, context.convert(tok, compClass));
            }
            catch (Exception e) {
                throw new ConversionException(e);
            }
            ++i;
        }
        return result;
    }
}

