/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import org.eclipse.packagedrone.web.controller.Controllers;
import org.eclipse.packagedrone.web.controller.routing.RequestMappingInformation;
import org.eclipse.scada.utils.str.StringReplacer;

public class LinkTarget {
    private static final Pattern PATTERN = Pattern.compile("\\{(.*?)\\}");
    private final String url;

    public LinkTarget(String url) {
        this.url = url;
    }

    public String render(final ServletRequest request) {
        return this.expandSource(new StringReplacer.ReplaceSource(){

            public String replace(String context, String key) {
                Object v = request.getAttribute(key);
                if (v == null) {
                    return context;
                }
                return v.toString();
            }
        }).getUrl();
    }

    public String render(PageContext pageContext) {
        return this.render(pageContext.getRequest());
    }

    public String renderFull(PageContext pageContext) {
        StringBuilder sb = new StringBuilder(pageContext.getServletContext().getContextPath());
        if (sb.length() > 0 && !sb.substring(sb.length() - 1).equals("/")) {
            sb.append('/');
        }
        sb.append(this.render(pageContext.getRequest()));
        return sb.toString();
    }

    public String render(Map<String, ?> model) {
        return this.expandSource(StringReplacer.newExtendedSource(model)).getUrl();
    }

    public LinkTarget expand(Map<String, ?> model) {
        return this.expandSource(StringReplacer.newExtendedSource(model));
    }

    public LinkTarget expandSource(StringReplacer.ReplaceSource source) {
        if (this.url == null || source == null) {
            return this;
        }
        EscaperSource encodeSource = new EscaperSource(source, UrlEscapers.urlPathSegmentEscaper());
        return new LinkTarget(StringReplacer.replace((String)this.url, (StringReplacer.ReplaceSource)encodeSource, (Pattern)PATTERN, (boolean)false));
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return String.format("[LinkTarget: %s]", this.url);
    }

    private static Set<String> getRawPaths(Class<?> controllerClazz, Method method) {
        RequestMappingInformation rmi = Controllers.fromMethod(controllerClazz, method);
        if (rmi == null) {
            return null;
        }
        return rmi.getRawPaths();
    }

    public static LinkTarget createFromController(ControllerMethod m) {
        Set<String> paths = LinkTarget.getRawPaths(m.getControllerClazz(), m.getMethod());
        if (paths != null && !paths.isEmpty()) {
            return new LinkTarget(paths.iterator().next());
        }
        throw new IllegalArgumentException(String.format("Controller class '%s' has no request method '%s'", m.getControllerClazz().getName(), m.getMethod().getName()));
    }

    public static LinkTarget createFromController(Class<?> controllerClazz, String methodName) {
        ControllerMethod m = LinkTarget.getControllerMethod(controllerClazz, methodName);
        if (m != null) {
            return LinkTarget.createFromController(m);
        }
        throw new IllegalArgumentException(String.format("Controller class '%s' has no request method '%s'", controllerClazz.getName(), methodName));
    }

    public static ControllerMethod getControllerMethod(Class<?> controllerClazz, String methodName) {
        Method[] methodArray = controllerClazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                return new ControllerMethod(controllerClazz, m);
            }
            ++n2;
        }
        return null;
    }

    public static class ControllerMethod {
        private final Class<?> controllerClazz;
        private final Method method;

        public ControllerMethod(Class<?> controllerClazz, Method method) {
            this.controllerClazz = controllerClazz;
            this.method = method;
        }

        public Class<?> getControllerClazz() {
            return this.controllerClazz;
        }

        public Method getMethod() {
            return this.method;
        }
    }

    public class EscaperSource
    implements StringReplacer.ReplaceSource {
        private final StringReplacer.ReplaceSource source;
        private final Escaper escaper;

        public EscaperSource(StringReplacer.ReplaceSource source, Escaper escaper) {
            this.source = source;
            this.escaper = escaper;
        }

        public String replace(String context, String key) {
            String result = this.source.replace(context, key);
            if (result != null) {
                return this.escaper.escape(result);
            }
            return result;
        }
    }
}

