/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.controller.routing.RequestMappingInformation;

public final class Controllers {
    public static RequestMappingInformation fromMethod(Class<?> controllerClazz, Method method) {
        RequestMapping methodAn = method.getAnnotation(RequestMapping.class);
        RequestMapping classAn = Controllers.getAnnotation(controllerClazz, RequestMapping.class);
        if (methodAn == null) {
            return null;
        }
        Set<String> httpMethods = Controllers.findHttpMethods(classAn, methodAn);
        Set<String> paths = Controllers.expandPaths(classAn, methodAn);
        if (httpMethods.isEmpty() || paths.isEmpty()) {
            return null;
        }
        return new RequestMappingInformation(paths, httpMethods);
    }

    private static Set<String> expandPaths(RequestMapping classAn, RequestMapping methodAn) {
        Set<String> classPaths = Controllers.toSet(classAn);
        Set<String> methodPaths = Controllers.toSet(methodAn);
        if (classPaths.isEmpty()) {
            return methodPaths;
        }
        if (methodPaths.isEmpty()) {
            return classPaths;
        }
        HashSet<String> result = new HashSet<String>();
        for (String base : classPaths) {
            for (String p : methodPaths) {
                result.add(String.valueOf(base) + p);
            }
        }
        return result;
    }

    protected static Set<String> toSet(RequestMapping classAn) {
        if (classAn != null && classAn.value() != null && classAn.value().length > 0) {
            return new HashSet<String>(Arrays.asList(classAn.value()));
        }
        return Collections.emptySet();
    }

    private static Set<String> findHttpMethods(RequestMapping classAn, RequestMapping methodAn) {
        if (methodAn != null && methodAn.method() != null && methodAn.method().length > 0) {
            return Controllers.toSet(methodAn.method());
        }
        if (classAn != null && classAn.method() != null && classAn.method().length > 0) {
            return Controllers.toSet(classAn.method());
        }
        return Collections.emptySet();
    }

    private static Set<String> toSet(RequestMethod[] methods) {
        HashSet<String> result = new HashSet<String>(methods.length);
        RequestMethod[] requestMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            RequestMethod method = requestMethodArray[n2];
            result.add(method.name());
            ++n2;
        }
        return result;
    }

    private static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        return clazz.getAnnotation(annotationClass);
    }
}

