/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import org.eclipse.packagedrone.utils.converter.ConvertBy;
import org.eclipse.packagedrone.utils.converter.ConverterManager;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binder;
import org.eclipse.packagedrone.web.controller.binding.Binding;
import org.eclipse.packagedrone.web.controller.binding.BindingManager;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.routing.RequestMappingInformation;

public class PathVariableBinder
implements Binder {
    private final RequestMappingInformation.Match match;

    public PathVariableBinder(RequestMappingInformation.Match match) {
        this.match = match;
    }

    @Override
    public Binding performBind(BindTarget target, ConverterManager converter, BindingManager bindingManager) {
        PathVariable pv = target.getAnnotation(PathVariable.class);
        if (pv == null) {
            return null;
        }
        String valueString = this.match.getAttributes().get(pv.value());
        try {
            Object value = converter.convertToBy((Object)valueString, target.getType(), () -> target.getAnnotationsByType(ConvertBy.class));
            return Binding.simpleBinding(value);
        }
        catch (Exception e) {
            return Binding.errorBinding(e);
        }
    }
}

