/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.apm.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.packagedrone.sec.service.apm.model.UserEntity;
import org.eclipse.packagedrone.sec.service.apm.model.UserModel;
import org.eclipse.packagedrone.sec.service.apm.model.UserWriteModel;
import org.eclipse.packagedrone.storage.apm.AbstractSimpleStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.util.ReplaceOnCloseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStorageModelProvider
extends AbstractSimpleStorageModelProvider<UserModel, UserWriteModel> {
    private static final Logger logger = LoggerFactory.getLogger(UserStorageModelProvider.class);

    public UserStorageModelProvider() {
        super(UserWriteModel.class);
    }

    public UserWriteModel cloneWriteModel(UserWriteModel writeModel) {
        return new UserWriteModel(writeModel);
    }

    public UserModel makeViewModelTyped(UserWriteModel writeModel) {
        return new UserModel(writeModel.getAll().values());
    }

    protected Gson createGson() {
        return new GsonBuilder().create();
    }

    protected Path makePath(StorageContext context) {
        return context.getBasePath().resolve("users.json");
    }

    protected void persistWriteModel(StorageContext context, UserWriteModel writeModel) throws Exception {
        if (!writeModel.isChanged()) {
            logger.trace("Write model unchanged");
            return;
        }
        Path path = this.makePath(context);
        logger.debug("Persisting model: {}", (Object)path.toAbsolutePath());
        Throwable throwable = null;
        Object var5_6 = null;
        try (ReplaceOnCloseWriter writer = new ReplaceOnCloseWriter(path, StandardCharsets.UTF_8);){
            this.createGson().toJson(writeModel.asCollection(), (Appendable)writer);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected UserWriteModel loadWriteModel(StorageContext context) throws Exception {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(this.makePath(context));){
                UserEntity[] users = (UserEntity[])this.createGson().fromJson((Reader)reader, UserEntity[].class);
                return new UserWriteModel(Arrays.asList(users), false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return new UserWriteModel();
        }
    }
}

